/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.data.valuemapping;

import com.agfa.hap.pacs.data.valuemapping.IValueMapping;
import java.text.DecimalFormat;

public abstract class AbstractValueMapping
implements IValueMapping {
    private static final ThreadLocal<DecimalFormat> DEFAULT_FORMAT = new LocalNumberFormat("#");
    private static final ThreadLocal<DecimalFormat> LARGE_VALUE_FORMAT = new LocalNumberFormat("##0.#E0");
    private static final ThreadLocal<DecimalFormat> SMALL_VALUE_FORMAT = new LocalNumberFormat("#.##");
    private static final ThreadLocal<DecimalFormat> TINY_VALUE_FORMAT = new LocalNumberFormat("0.###");
    private static final int LARGE_VALUE_THRESHOLD = 1000000;
    private static final int SMALL_VALUE_THRESHOLD = 10;
    private static final int TINY_VALUE_THRESHOLD = 1;

    @Override
    public Integer getFirstValueMapped() {
        return null;
    }

    @Override
    public Integer getLastValueMapped() {
        return null;
    }

    @Override
    public String formatValue(double d) {
        if (Double.isNaN(d)) {
            return "NA";
        }
        ThreadLocal<DecimalFormat> threadLocal = -1.0 < d && d < 1.0 ? TINY_VALUE_FORMAT : (-10.0 < d && d < 10.0 ? SMALL_VALUE_FORMAT : (-1000000.0 < d && d < 1000000.0 ? DEFAULT_FORMAT : LARGE_VALUE_FORMAT));
        return threadLocal.get().format(d);
    }

    private static class LocalNumberFormat
    extends ThreadLocal<DecimalFormat> {
        private final String pattern;

        public LocalNumberFormat(String string) {
            this.pattern = string;
        }

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat(this.pattern);
        }
    }
}

