/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.data.valuemapping;

import com.agfa.hap.pacs.data.valuemapping.AbstractValueMapping;
import com.agfa.hap.pacs.data.valuemapping.IValueMapping;
import com.agfa.hap.pacs.data.valuemapping.IValueMappingOption;
import com.agfa.hap.pacs.data.valuemapping.IValueMappingProperties;
import com.agfa.hap.pacs.data.valuemapping.ValueMappingUtils;
import com.agfa.pacs.data.shared.code.Code;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RealWorldValueMapping
extends AbstractValueMapping
implements IValueMappingOption {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealWorldValueMapping.class);
    private final int firstValueMapped;
    private final int lastValueMapped;
    private final double slope;
    private final double intercept;
    private final double[] lutData;
    private final String lutExplanation;
    private final String lutLabel;
    private final Code measurementUnit;
    private final boolean isMonotonic;

    private RealWorldValueMapping(Attributes attributes, IntFunction<String> intFunction, int n) {
        this.firstValueMapped = RealWorldValueMapping.getInt(attributes, 4231702, Integer.MIN_VALUE);
        this.lastValueMapped = RealWorldValueMapping.getInt(attributes, 4231697, Integer.MAX_VALUE);
        if (attributes.containsValue(4231717) && attributes.containsValue(4231716)) {
            this.slope = attributes.getDouble(4231717, 0.0);
            this.intercept = attributes.getDouble(4231716, 0.0);
            this.lutData = null;
            this.isMonotonic = true;
        } else {
            this.slope = 1.0;
            this.intercept = 0.0;
            this.lutData = attributes.getDoubles(4231698);
            this.isMonotonic = RealWorldValueMapping.checkMonotonicity(this.lutData);
        }
        this.lutLabel = RealWorldValueMapping.readLabel(attributes, intFunction, n);
        this.lutExplanation = RealWorldValueMapping.getString(attributes, 2633731, this.lutLabel);
        this.measurementUnit = Code.create(attributes, 4196586);
    }

    private static int getInt(Attributes attributes, int n, int n2) {
        return attributes.getInt(n, n2);
    }

    private static String getString(Attributes attributes, int n, String string) {
        if (attributes.contains(n)) {
            return attributes.getString(n);
        }
        return string;
    }

    private static String readLabel(Attributes attributes, IntFunction<String> intFunction, int n) {
        String string = attributes.getString(4231696);
        if (string == null) {
            string = intFunction.apply(n);
        }
        return string;
    }

    public static List<RealWorldValueMapping> create(Attributes attributes, IntFunction<String> intFunction) {
        if (attributes == null) {
            return Collections.emptyList();
        }
        Sequence sequence = attributes.getSequence(4231318);
        if (sequence == null) {
            return Collections.emptyList();
        }
        int n = sequence.size();
        ArrayList<RealWorldValueMapping> arrayList = new ArrayList<RealWorldValueMapping>(n);
        int n2 = 0;
        while (n2 < n) {
            try {
                RealWorldValueMapping realWorldValueMapping = new RealWorldValueMapping((Attributes)sequence.get(n2), intFunction, n2);
                if (realWorldValueMapping.isValid()) {
                    arrayList.add(realWorldValueMapping);
                } else {
                    LOGGER.debug("RealWorldValueMapping skipped: {}", (Object)realWorldValueMapping);
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Parsing RealWorldValueMapping failed", (Throwable)exception);
            }
            ++n2;
        }
        return arrayList;
    }

    private static boolean checkMonotonicity(double[] dArray) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 1;
        while (n < dArray.length) {
            double d = dArray[n] - dArray[n - 1];
            if (d > 0.0) {
                bl = true;
            }
            if (d < 0.0) {
                bl2 = true;
            }
            ++n;
        }
        return bl ^ bl2;
    }

    @Override
    public IValueMapping createValueMapping(IValueMappingProperties iValueMappingProperties) {
        for (IValueMapping iValueMapping : iValueMappingProperties.getRealWorldValueMappings()) {
            if (!this.isEquivalent(iValueMapping)) continue;
            return iValueMapping;
        }
        return null;
    }

    @Override
    public double applyMapping(int n) {
        if (n < this.firstValueMapped || n > this.lastValueMapped) {
            return Double.NaN;
        }
        if (this.lutData == null) {
            return this.slope * (double)n + this.intercept;
        }
        if (n - this.firstValueMapped < this.lutData.length) {
            return this.lutData[n - this.firstValueMapped];
        }
        return Double.NaN;
    }

    @Override
    public String getUnit() {
        if (this.measurementUnit == null) {
            return null;
        }
        return this.measurementUnit.getCodeValue();
    }

    @Override
    public Integer getFirstValueMapped() {
        return this.firstValueMapped;
    }

    @Override
    public Integer getLastValueMapped() {
        return this.lastValueMapped;
    }

    @Override
    public String getLabel() {
        return IValueMappingOption.createLabel(this.lutLabel, this.getUnit());
    }

    @Override
    public String getDescription() {
        return this.lutExplanation;
    }

    @Override
    public boolean isMonotonic() {
        return this.isMonotonic;
    }

    private boolean isValid() {
        return this.firstValueMapped < this.lastValueMapped && !ValueMappingUtils.isEqual(this.slope, 0.0);
    }

    public boolean isEquivalent(IValueMapping iValueMapping) {
        if (iValueMapping instanceof RealWorldValueMapping) {
            return this.isEquivalent((RealWorldValueMapping)iValueMapping);
        }
        return false;
    }

    private boolean isEquivalent(RealWorldValueMapping realWorldValueMapping) {
        return Objects.equals(this.lutLabel, realWorldValueMapping.lutLabel) && Objects.equals(this.getUnit(), realWorldValueMapping.getUnit());
    }

    public boolean equals(Object object) {
        if (!(object instanceof RealWorldValueMapping)) {
            return false;
        }
        RealWorldValueMapping realWorldValueMapping = (RealWorldValueMapping)object;
        return this.firstValueMapped == realWorldValueMapping.firstValueMapped && this.lastValueMapped == realWorldValueMapping.lastValueMapped && ValueMappingUtils.isEqual(this.slope, realWorldValueMapping.slope) && ValueMappingUtils.isEqual(this.intercept, realWorldValueMapping.intercept) && Arrays.equals(this.lutData, realWorldValueMapping.lutData) && Objects.equals(this.lutExplanation, realWorldValueMapping.lutExplanation) && Objects.equals(this.lutLabel, realWorldValueMapping.lutLabel) && Objects.equals(this.measurementUnit, realWorldValueMapping.measurementUnit);
    }

    public int hashCode() {
        return this.firstValueMapped ^ this.lastValueMapped ^ Double.valueOf(this.slope).hashCode() ^ Double.valueOf(this.intercept).hashCode() ^ Objects.hashCode(this.lutData) ^ Objects.hashCode(this.lutExplanation) ^ Objects.hashCode(this.lutLabel) ^ Objects.hashCode(this.measurementUnit);
    }

    public String toString() {
        return this.getLabel();
    }
}

