/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.data.valuemapping;

import com.agfa.hap.pacs.data.DateUtilities;
import com.agfa.hap.pacs.data.valuemapping.DecayCorrectionMethod;
import com.agfa.hap.pacs.data.valuemapping.IIsotope;
import com.agfa.hap.pacs.data.valuemapping.ISUVData;
import com.agfa.hap.pacs.data.valuemapping.ISUVStudyData;
import com.agfa.hap.pacs.data.valuemapping.IStandardizedUptakeValueMethod;
import com.agfa.hap.pacs.data.valuemapping.NamedIsotope;
import com.agfa.hap.pacs.data.valuemapping.PatientSex;
import com.agfa.hap.pacs.data.valuemapping.SUVIsotope;
import com.agfa.hap.pacs.data.valuemapping.SUVStudyData;
import com.agfa.hap.pacs.data.valuemapping.ValueMappingUtils;
import com.agfa.pacs.data.shared.code.Code;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;

public class SUVData
implements ISUVData {
    public static final double MEGABECQUEREL = 1000000.0;
    static final double MILLISECONDS_PER_SECOND = 1000.0;
    private final ISUVStudyData suvStudyData;
    private final IIsotope isotopeFromData;
    private IIsotope isotope;
    private Double injectedDose;
    private Date injectionTime;
    private final Date baseDateTimeOverride;
    private final DecayCorrectionMethod decayCorrectionMethod;
    private final boolean isDataFromDicomComplete;

    public SUVData(Attributes attributes, IStandardizedUptakeValueMethod iStandardizedUptakeValueMethod) {
        this(attributes, null, new SUVStudyData(attributes, iStandardizedUptakeValueMethod));
    }

    public SUVData(Attributes attributes, Date date, ISUVStudyData iSUVStudyData) {
        this.suvStudyData = iSUVStudyData;
        Attributes attributes2 = SUVData.extractInjectionData(attributes);
        Double d = SUVData.getDouble(attributes2, 1577077);
        if (d == null) {
            this.isotopeFromData = null;
            this.isotope = NamedIsotope.getIsotopeByCode(Code.create(attributes2, 5505796), Code.create(attributes2, 5505792));
        } else {
            this.isotope = this.isotopeFromData = SUVIsotope.createIsotopeFromData(d);
        }
        this.injectedDose = SUVData.getDouble(attributes2, 1577076);
        if (this.injectedDose != null && this.injectedDose < 1000000.0) {
            this.injectedDose = this.injectedDose * 1000000.0;
        }
        this.injectionTime = SUVData.readInjectionTime(attributes2, attributes);
        this.baseDateTimeOverride = date;
        this.decayCorrectionMethod = DecayCorrectionMethod.create(attributes);
        this.isDataFromDicomComplete = !this.needsData();
    }

    private SUVData(SUVData sUVData) {
        this.suvStudyData = sUVData.suvStudyData.createCopy();
        this.isotopeFromData = sUVData.isotopeFromData;
        this.isotope = sUVData.isotope;
        this.injectedDose = sUVData.injectedDose;
        this.injectionTime = SUVData.copyDate(sUVData.injectionTime);
        this.baseDateTimeOverride = SUVData.copyDate(sUVData.baseDateTimeOverride);
        this.decayCorrectionMethod = sUVData.decayCorrectionMethod;
        this.isDataFromDicomComplete = sUVData.isDataFromDicomComplete;
    }

    private static Date copyDate(Date date) {
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    static Double getDouble(Attributes attributes, int n) {
        if (attributes.contains(n)) {
            return attributes.getDouble(n, 0.0);
        }
        return null;
    }

    private static Attributes extractInjectionData(Attributes attributes) {
        Sequence sequence = attributes.getSequence(5505046);
        if (sequence == null || sequence.isEmpty()) {
            return new Attributes();
        }
        return (Attributes)sequence.get(0);
    }

    private static Date readInjectionTime(Attributes attributes, Attributes attributes2) {
        Date date;
        if (attributes.containsValue(1577080)) {
            date = attributes.getDate(1577080);
        } else if (attributes.containsValue(1577074)) {
            Date date2 = SUVData.getTimeZoneUncorrectedDate(attributes2, 524322, VR.DA);
            Date date3 = SUVData.getTimeZoneUncorrectedDate(attributes, 1577074, VR.TM);
            date = SUVData.applyTimeZoneCorrection(DateUtilities.createDateTime(date2, date3), attributes2);
            Date date4 = ValueMappingUtils.getDateAndTime(2251945843097650L, attributes2);
            if (date != null && date4 != null && date.after(date4)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(5, -1);
                date = calendar.getTime();
            }
        } else {
            date = null;
        }
        return date;
    }

    private static Date applyTimeZoneCorrection(Date date, Attributes attributes) {
        LocalDateTime localDateTime = LocalDateTime.from(date.toInstant().atZone(ZoneId.systemDefault()));
        ZoneId zoneId = attributes.getTimeZone().toZoneId();
        ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);
        return Date.from(zonedDateTime.toInstant());
    }

    private static Date getTimeZoneUncorrectedDate(Attributes attributes, int n, VR vR) {
        String string = attributes.getString(n);
        if (string == null) {
            return null;
        }
        return vR.toDate((Object)string, TimeZone.getDefault(), 0, false, null, new DatePrecision());
    }

    @Override
    public boolean isDataFromDicomComplete() {
        return this.isDataFromDicomComplete;
    }

    @Override
    public final boolean needsData() {
        return this.injectionTime == null || SUVData.isInvalid(this.isotope.getHalfLife()) || SUVData.isInvalid(this.injectedDose) || this.suvStudyData.needsData();
    }

    public static boolean isInvalid(Double d) {
        return d == null || ValueMappingUtils.isEqual(d, 0.0);
    }

    @Override
    public IStandardizedUptakeValueMethod getMethod() {
        return this.suvStudyData.getMethod();
    }

    @Override
    public void setMethod(IStandardizedUptakeValueMethod iStandardizedUptakeValueMethod) {
        this.suvStudyData.setMethod(iStandardizedUptakeValueMethod);
    }

    @Override
    public PatientSex getPatientSex() {
        return this.suvStudyData.getPatientSex();
    }

    @Override
    public void setPatientSex(PatientSex patientSex) {
        this.suvStudyData.setPatientSex(patientSex);
    }

    @Override
    public Double getPatientWeight() {
        return this.suvStudyData.getPatientWeight();
    }

    @Override
    public void setPatientWeight(Double d) {
        this.suvStudyData.setPatientWeight(d);
    }

    @Override
    public Double getPatientHeight() {
        return this.suvStudyData.getPatientHeight();
    }

    @Override
    public void setPatientHeight(Double d) {
        this.suvStudyData.setPatientHeight(d);
    }

    @Override
    public IIsotope getIsotopeFromData() {
        return this.isotopeFromData;
    }

    @Override
    public IIsotope getIsotope() {
        return this.isotope;
    }

    @Override
    public void setIsotope(IIsotope iIsotope) {
        this.isotope = iIsotope == null ? SUVIsotope.CUSTOM : iIsotope;
    }

    @Override
    public Double getInjectedDose() {
        return this.injectedDose;
    }

    @Override
    public void setInjectedDose(Double d) {
        this.injectedDose = d;
    }

    @Override
    public Date getInjectionTime() {
        return this.injectionTime;
    }

    @Override
    public Double getAcquisitionDelay(Attributes attributes) {
        return this.decayCorrectionMethod.getAcquisitionDelay(attributes, this);
    }

    @Override
    public void setAcquisitionDelay(Date date, Double d) {
        this.injectionTime = SUVData.calculateInjectionTime(date, d);
    }

    @Override
    public ISUVData.AcquisitionDelayStatus getAcquisitionDelayStatus(Iterable<Attributes> iterable) {
        Iterator<Attributes> iterator = iterable.iterator();
        if (!iterator.hasNext() || this.decayCorrectionMethod.needsData(this)) {
            return ISUVData.AcquisitionDelayStatus.UNKNOWN;
        }
        Double d = this.getAcquisitionDelay(iterator.next());
        if (d == null) {
            return ISUVData.AcquisitionDelayStatus.NULL_VALUES;
        }
        if (this.baseDateTimeOverride != null) {
            return ISUVData.AcquisitionDelayStatus.ALL_EQUAL;
        }
        return this.analyzeAcquisitionDelays(iterable, d);
    }

    private ISUVData.AcquisitionDelayStatus analyzeAcquisitionDelays(Iterable<Attributes> iterable, double d) {
        for (Attributes attributes : iterable) {
            Double d2 = this.getAcquisitionDelay(attributes);
            if (d2 == null) {
                return ISUVData.AcquisitionDelayStatus.NULL_VALUES;
            }
            if (ValueMappingUtils.isEqual(d2, d)) continue;
            return ISUVData.AcquisitionDelayStatus.DIFFERENT;
        }
        return ISUVData.AcquisitionDelayStatus.ALL_EQUAL;
    }

    @Override
    public ISUVData createCopy() {
        return new SUVData(this);
    }

    Date getBaseDateTimeOverride() {
        return this.baseDateTimeOverride;
    }

    public static Double calculateAcquisitionDelay(Date date, Date date2) {
        if (date == null || date2 == null) {
            return null;
        }
        return (double)(date.getTime() - date2.getTime()) / 1000.0;
    }

    public static Date calculateInjectionTime(Date date, Double d) {
        Date date2 = date == null || d == null ? null : new Date(date.getTime() - (long)(d * 1000.0));
        return date2;
    }
}

