/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.data.valuemapping;

import com.agfa.hap.pacs.data.valuemapping.IIsotope;
import java.util.Objects;

public final class SUVIsotope
implements IIsotope {
    public static final IIsotope CUSTOM = new SUVIsotope(null, true);
    private final Double halfLife;
    private final boolean isCustom;

    private SUVIsotope(Double d, boolean bl) {
        this.halfLife = d;
        this.isCustom = bl;
    }

    static IIsotope createIsotopeFromData(double d) {
        return new SUVIsotope(d, false);
    }

    public static IIsotope createCustomIsotope(Double d) {
        if (d == null) {
            return CUSTOM;
        }
        return new SUVIsotope(d, true);
    }

    @Override
    public Double getHalfLife() {
        return this.halfLife;
    }

    @Override
    public boolean isEditable() {
        return this.isCustom;
    }

    public boolean equals(Object object) {
        if (object instanceof SUVIsotope) {
            SUVIsotope sUVIsotope = (SUVIsotope)object;
            return this.isCustom == sUVIsotope.isCustom && Objects.equals(this.halfLife, sUVIsotope.halfLife);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.halfLife) ^ Boolean.hashCode(this.isCustom);
    }
}

