/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.data.valuemapping;

import com.agfa.hap.pacs.data.valuemapping.IPatientBodyData;
import com.agfa.hap.pacs.data.valuemapping.IStandardizedUptakeValueMethod;
import com.agfa.hap.pacs.data.valuemapping.PatientSex;
import com.agfa.hap.pacs.data.valuemapping.SUVData;
import org.apache.commons.lang3.ArrayUtils;

public enum StandardizedUptakeValueMethod implements IStandardizedUptakeValueMethod
{
    BodyWeight("bw", Unit.G_PER_ML){

        @Override
        public boolean isValidGender(IPatientBodyData iPatientBodyData) {
            return true;
        }

        @Override
        public boolean isValidHeight(IPatientBodyData iPatientBodyData) {
            return true;
        }

        @Override
        public double getPatientSizeFactor(IPatientBodyData iPatientBodyData) {
            return iPatientBodyData.getPatientWeight() * 1000.0;
        }
    }
    ,
    BodySurfaceArea("bsa", Unit.CM2_PER_ML){

        @Override
        public boolean isValidGender(IPatientBodyData iPatientBodyData) {
            return true;
        }

        @Override
        public double getPatientSizeFactor(IPatientBodyData iPatientBodyData) {
            return Math.pow(iPatientBodyData.getPatientWeight(), 0.425) * Math.pow(iPatientBodyData.getPatientHeight(), 0.725) * 71.84;
        }
    }
    ,
    LeanBodyMass("lbm", Unit.G_PER_ML){

        @Override
        public double getPatientSizeFactor(IPatientBodyData iPatientBodyData) {
            double d;
            double d2;
            if (iPatientBodyData.getPatientHeight() == 0.0) {
                return 0.0;
            }
            switch (iPatientBodyData.getPatientSex()) {
                case Male: {
                    d2 = 1.1;
                    d = 128.0;
                    break;
                }
                case Female: {
                    d2 = 1.07;
                    d = 148.0;
                    break;
                }
                default: {
                    return 0.0;
                }
            }
            double d3 = iPatientBodyData.getPatientWeight();
            return 1000.0 * (d2 * d3 - d * StandardizedUptakeValueMethod.squared(d3 / iPatientBodyData.getPatientHeight()));
        }
    }
    ,
    LeanBodyMass_Janmahasatian("lbm", "Janma", Unit.G_PER_ML){

        @Override
        public double getPatientSizeFactor(IPatientBodyData iPatientBodyData) {
            double d;
            double d2;
            if (iPatientBodyData.getPatientHeight() == 0.0) {
                return 0.0;
            }
            switch (iPatientBodyData.getPatientSex()) {
                case Male: {
                    d2 = 6680.0;
                    d = 216.0;
                    break;
                }
                case Female: {
                    d2 = 8780.0;
                    d = 244.0;
                    break;
                }
                default: {
                    return 0.0;
                }
            }
            double d3 = iPatientBodyData.getPatientWeight();
            return 9270000.0 * d3 / (d2 + d * d3 / StandardizedUptakeValueMethod.squared(iPatientBodyData.getPatientHeight()));
        }
    };

    private final String abbreviation;
    private final String variantName;
    private final Unit unit;

    private StandardizedUptakeValueMethod(String string2, Unit unit) {
        this(string2, null, unit);
    }

    private StandardizedUptakeValueMethod(String string2, String string3, Unit unit) {
        this.abbreviation = string2;
        this.variantName = string3;
        this.unit = unit;
    }

    public static StandardizedUptakeValueMethod[] valuesLegacy() {
        return new StandardizedUptakeValueMethod[]{BodyWeight, BodySurfaceArea, LeanBodyMass};
    }

    public static StandardizedUptakeValueMethod valueOfLegacy(String string) {
        StandardizedUptakeValueMethod standardizedUptakeValueMethod = StandardizedUptakeValueMethod.valueOf(string);
        if (ArrayUtils.contains((Object[])StandardizedUptakeValueMethod.valuesLegacy(), (Object)standardizedUptakeValueMethod)) {
            return standardizedUptakeValueMethod;
        }
        throw new IllegalArgumentException("No legacy enum constant " + StandardizedUptakeValueMethod.class.getCanonicalName() + '.' + string);
    }

    private static double squared(double d) {
        return d * d;
    }

    @Override
    public String getName() {
        StringBuilder stringBuilder = new StringBuilder("SUV").append(this.abbreviation);
        if (this.variantName != null) {
            stringBuilder.append(' ').append(this.variantName);
        }
        return stringBuilder.toString();
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    @Override
    public String getUnit() {
        return this.unit.abbreviation;
    }

    @Override
    public boolean isValidGender(IPatientBodyData iPatientBodyData) {
        PatientSex patientSex = iPatientBodyData.getPatientSex();
        return patientSex == PatientSex.Male || patientSex == PatientSex.Female;
    }

    @Override
    public boolean isValidWeight(IPatientBodyData iPatientBodyData) {
        return !SUVData.isInvalid(iPatientBodyData.getPatientWeight());
    }

    @Override
    public boolean isValidHeight(IPatientBodyData iPatientBodyData) {
        return !SUVData.isInvalid(iPatientBodyData.getPatientHeight());
    }

    @Override
    public IStandardizedUptakeValueMethod createCopy() {
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("<html>SUV<sub>");
        stringBuilder.append(this.abbreviation);
        stringBuilder.append("</sub>");
        if (this.variantName != null) {
            stringBuilder.append(" (").append(this.variantName).append(')');
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    @Override
    public String getKey() {
        return this.name();
    }

    /* synthetic */ StandardizedUptakeValueMethod(String string, int n, String string2, Unit unit, StandardizedUptakeValueMethod standardizedUptakeValueMethod) {
        this(string2, unit);
    }

    /* synthetic */ StandardizedUptakeValueMethod(String string, int n, String string2, String string3, Unit unit, StandardizedUptakeValueMethod standardizedUptakeValueMethod) {
        this(string2, string3, unit);
    }

    private static enum Unit {
        CM2_PER_ML("cm\u00b2/ml"),
        G_PER_ML("g/ml");

        private final String abbreviation;

        private Unit(String string2) {
            this.abbreviation = string2;
        }

        public String toString() {
            return this.abbreviation;
        }
    }
}

