/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.util;

import com.agfa.hap.pacs.data.dicom.DataTypeForVR;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.DateUtils;
import org.dcm4che3.util.TagUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dcm4cheUtils {
    private static final Logger log = LoggerFactory.getLogger(Dcm4cheUtils.class);
    private static final Map<String, String> CHARSET = new HashMap<String, String>();
    private static final DatePrecision PERFECT_PRECISION = new DatePrecision();

    static {
        CHARSET.put("", "US-ASCII");
        CHARSET.put("ISO_IR 100", "ISO-8859-1");
        CHARSET.put("ISO_IR 101", "ISO-8859-2");
        CHARSET.put("ISO_IR 109", "ISO-8859-3");
        CHARSET.put("ISO_IR 110", "ISO-8859-4");
        CHARSET.put("ISO_IR 144", "ISO-8859-5");
        CHARSET.put("ISO_IR 127", "ISO-8859-6");
        CHARSET.put("ISO_IR 126", "ISO-8859-7");
        CHARSET.put("ISO_IR 138", "ISO-8859-8");
        CHARSET.put("ISO_IR 148", "ISO-8859-9");
        CHARSET.put("ISO_IR 13", "JIS_X0201");
        CHARSET.put("ISO_IR 166", "TIS-620");
        CHARSET.put("ISO 2022 IR 6", "US-ASCII");
        CHARSET.put("ISO 2022 IR 100", "ISO-8859-1");
        CHARSET.put("ISO 2022 IR 101", "ISO-8859-2");
        CHARSET.put("ISO 2022 IR 109", "ISO-8859-3");
        CHARSET.put("ISO 2022 IR 110", "ISO-8859-4");
        CHARSET.put("ISO 2022 IR 144", "ISO-8859-5");
        CHARSET.put("ISO 2022 IR 127", "ISO-8859-6");
        CHARSET.put("ISO 2022 IR 126", "ISO-8859-7");
        CHARSET.put("ISO 2022 IR 138", "ISO-8859-8");
        CHARSET.put("ISO 2022 IR 148", "ISO-8859-9");
        CHARSET.put("ISO 2022 IR 13", "JIS_X0201");
        CHARSET.put("ISO 2022 IR 166", "TIS-620");
        CHARSET.put("ISO 2022 IR 87", "JIS0208");
        CHARSET.put("ISO 2022 IR 159", "JIS0212");
        CHARSET.put("ISO 2022 IR 149", "cp949");
        CHARSET.put("ISO_IR 192", "UTF-8");
        CHARSET.put("GB18030", "GB18030");
    }

    public static String getString(int[] nArray, Attributes attributes) {
        if (nArray.length == 1) {
            return attributes.getString(nArray[0]);
        }
        if ((attributes = Dcm4cheUtils.getNestedDataset(nArray, attributes, false)) == null) {
            return null;
        }
        return attributes.getString(nArray[nArray.length - 1]);
    }

    public static final Attributes getNestedDataset(int[] nArray, Attributes attributes, boolean bl) {
        if (nArray == null || nArray.length == 1) {
            return attributes;
        }
        int n = 0;
        Sequence sequence = null;
        while (n != nArray.length - 1) {
            if (attributes.containsValue(nArray[n])) {
                sequence = attributes.getSequence(nArray[n]);
            } else if (bl) {
                sequence = attributes.newSequence(nArray[n], 1);
            }
            if (sequence == null) {
                return null;
            }
            if (sequence.size() > nArray[n + 1]) {
                attributes = (Attributes)sequence.get(nArray[n + 1]);
            } else if (bl) {
                attributes = new Attributes();
                sequence.add(attributes);
            } else {
                return null;
            }
            n += 2;
            sequence = null;
        }
        return attributes;
    }

    public static String getBytesAsString(Attributes attributes, int ... nArray) {
        Attributes attributes2 = Dcm4cheUtils.getNestedDataset(nArray, attributes, false);
        if (attributes2 == null || nArray == null) {
            return null;
        }
        int n = nArray[nArray.length - 1];
        try {
            return attributes2.getSpecificCharacterSet().decode(attributes2.getBytes(n));
        }
        catch (Exception exception) {
            log.warn("Parsing byte value as string failed for {}", (Object)Arrays.toString(nArray));
            return null;
        }
    }

    public static String[] getStrings(int[] nArray, Attributes attributes) {
        if ((attributes = Dcm4cheUtils.getNestedDataset(nArray, attributes, false)) == null || nArray == null) {
            return null;
        }
        return attributes.getStrings(nArray[nArray.length - 1]);
    }

    public static int getInt(int[] nArray, Attributes attributes, int n) {
        Attributes attributes2 = Dcm4cheUtils.getNestedDataset(nArray, attributes, false);
        if (attributes2 == null || nArray == null) {
            return n;
        }
        return attributes2.getInt(nArray[nArray.length - 1], n);
    }

    public static double getDouble(int[] nArray, Attributes attributes, double d) {
        Attributes attributes2 = Dcm4cheUtils.getNestedDataset(nArray, attributes, false);
        if (attributes2 == null || nArray == null) {
            return d;
        }
        return attributes2.getDouble(nArray[nArray.length - 1], d);
    }

    public static Date getDate(int[] nArray, Attributes attributes) {
        Attributes attributes2 = Dcm4cheUtils.getNestedDataset(nArray, attributes, false);
        if (attributes2 == null || nArray == null) {
            return null;
        }
        return Dcm4cheUtils.getDate(nArray[nArray.length - 1], attributes2);
    }

    public static Class<?> getValueFormatClassForTag(int n) {
        DataTypeForVR dataTypeForVR = Dcm4cheUtils.getDataType(n);
        if (dataTypeForVR == null) {
            return null;
        }
        return dataTypeForVR.getValueClass();
    }

    public static DataTypeForVR getDataType(int n) {
        if (n < 0) {
            return null;
        }
        VR vR = ElementDictionary.vrOf((int)n, null);
        if (vR != null && vR != VR.OB && vR != VR.OW && vR != VR.UN) {
            return DataTypeForVR.getDataType(vR);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static Date getDateTime(long l, Attributes attributes) {
        block7: {
            String string;
            String string2;
            int n;
            int n2;
            block8: {
                if (l != 4503805786849330L) break block7;
                n2 = (int)(l >>> 32);
                n = (int)l;
                string2 = attributes.getString(null, n, VR.TM, null);
                if (string2 == null) {
                    return Dcm4cheUtils.getDate(n2, attributes);
                }
                string = attributes.getString(null, n2, VR.DA, null);
                if (string != null) break block8;
                return null;
                {
                    catch (IllegalArgumentException illegalArgumentException) {
                        log.warn("Parsing date failed", (Throwable)illegalArgumentException);
                        return null;
                    }
                }
            }
            try {
                return DateUtils.parseDT(null, (String)(String.valueOf(string) + string2), (DatePrecision)PERFECT_PRECISION);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.info("Invalid value of {} DA or {} TM", (Object)TagUtils.toString((int)n2), (Object)TagUtils.toString((int)n));
                return null;
            }
        }
        return attributes.getDate(l, PERFECT_PRECISION);
    }

    public static Date getDate(int n, Attributes attributes) {
        return Dcm4cheUtils.getDate(null, attributes, n, 0);
    }

    private static Date getDate(String string, Attributes attributes, int n, int n2, int n3) {
        long l = ((long)n << 32) + (long)n2;
        if (n3 == 0) {
            return attributes.getDate(string, l, PERFECT_PRECISION);
        }
        Date[] dateArray = attributes.getDates(string, l);
        if (dateArray != null && dateArray.length > n3) {
            return dateArray[n3];
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Date getDate(String string, Attributes attributes, int n, int n2) {
        try {
            ElementDictionary elementDictionary = ElementDictionary.getElementDictionary((String)string);
            VR vR = elementDictionary.vrOf(n);
            if (n == 0x100030 || n == 1048626) {
                return Dcm4cheUtils.getUncorrectedDate(string, n, vR, attributes, n2);
            }
            if (vR == VR.DA) {
                int n3 = elementDictionary.tmTagOf(n);
                if (n3 == 0) {
                    return Dcm4cheUtils.getUncorrectedDate(string, n, vR, attributes, n2);
                }
                return Dcm4cheUtils.getDate(string, attributes, n, n3, n2);
            }
            if (vR == VR.TM) {
                if (attributes.getString(string, n, n2) == null) {
                    return null;
                }
                int n4 = elementDictionary.daTagOf(n);
                if (n4 == 0) {
                    return Dcm4cheUtils.getUncorrectedDate(string, n, vR, attributes, n2);
                }
                return Dcm4cheUtils.getDate(string, attributes, n4, n, n2);
            }
            if (vR == VR.DT) {
                return attributes.getDate(string, n, n2, PERFECT_PRECISION);
            }
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn("Parsing date failed", (Throwable)illegalArgumentException);
            return null;
        }
    }

    public static Date getUncorrectedDate(String string, int n, VR vR, Attributes attributes, int n2) {
        String string2 = attributes.getString(string, n, n2);
        if (string2 == null) {
            return null;
        }
        if (vR == VR.DA) {
            return DateUtils.parseDA(null, (String)string2);
        }
        return DateUtils.parseTM(null, (String)string2, (DatePrecision)PERFECT_PRECISION);
    }

    public static String getStandardNameForTag(int n) {
        String string = ElementDictionary.keywordOf((int)n, null);
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        boolean bl = false;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (bl && Character.isUpperCase(c)) {
                bl = false;
                stringBuilder.append(' ').append(c);
            } else {
                stringBuilder.append(c);
                bl = Character.isLowerCase(c);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static int getTagFromString(String string) {
        if (string.length() != 11) {
            throw new IllegalArgumentException("Illegal format");
        }
        String string2 = string.substring(1, 5);
        String string3 = string.substring(6, 10);
        int n = Integer.parseInt(string2, 16);
        int n2 = Integer.parseInt(string3, 16);
        return (n << 16) + n2;
    }

    public static String getCharsetName(Attributes attributes) {
        String string = attributes.getString(524293);
        try {
            return CHARSET.get(string);
        }
        catch (Exception exception) {
            log.warn("could not get charset name for " + string, (Throwable)exception);
            return null;
        }
    }
}

