/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.image.PhotometricInterpretation;

public class ImageUtils {
    public static Attributes readImageAttributes(BufferedImage bufferedImage) {
        Attributes attributes = new Attributes();
        attributes.setInt(2621456, VR.US, new int[]{bufferedImage.getHeight()});
        attributes.setInt(2621457, VR.US, new int[]{bufferedImage.getWidth()});
        switch (bufferedImage.getType()) {
            case 10: {
                attributes.setInt(0x280002, VR.US, new int[]{1});
                attributes.setInt(2621696, VR.US, new int[]{8});
                attributes.setInt(2621697, VR.US, new int[]{8});
                attributes.setInt(2621698, VR.US, new int[]{7});
                attributes.setString(2621444, VR.CS, PhotometricInterpretation.MONOCHROME2.name());
                attributes.setInt(2621699, VR.US, new int[]{0});
                break;
            }
            case 11: {
                attributes.setInt(0x280002, VR.US, new int[]{1});
                attributes.setInt(2621696, VR.US, new int[]{16});
                attributes.setInt(2621697, VR.US, new int[]{16});
                attributes.setInt(2621698, VR.US, new int[]{15});
                attributes.setString(2621444, VR.CS, PhotometricInterpretation.MONOCHROME2.name());
                attributes.setInt(2621699, VR.US, new int[]{0});
                break;
            }
            case 1: {
                attributes.setInt(0x280002, VR.US, new int[]{3});
                attributes.setInt(2621696, VR.US, new int[]{8});
                attributes.setInt(2621697, VR.US, new int[]{8});
                attributes.setInt(2621698, VR.US, new int[]{7});
                attributes.setString(2621444, VR.CS, PhotometricInterpretation.RGB.name());
                attributes.setInt(2621699, VR.US, new int[]{0});
                attributes.setInt(2621446, VR.US, new int[]{0});
                break;
            }
            default: {
                if (bufferedImage.getColorModel().getColorSpace().getType() == 6) {
                    attributes.setString(2621444, VR.CS, PhotometricInterpretation.MONOCHROME2.name());
                    attributes.setInt(2621699, VR.US, new int[]{0});
                    attributes.setInt(0x280002, VR.US, new int[]{1});
                    int[] nArray = bufferedImage.getSampleModel().getSampleSize();
                    if (nArray[0] <= 8) {
                        attributes.setInt(2621696, VR.US, new int[]{8});
                        attributes.setInt(2621697, VR.US, new int[]{8});
                        attributes.setInt(2621698, VR.US, new int[]{7});
                        break;
                    }
                    attributes.setInt(2621696, VR.US, new int[]{16});
                    attributes.setInt(2621697, VR.US, new int[]{8});
                    attributes.setInt(2621698, VR.US, new int[]{15});
                    break;
                }
                attributes.setInt(0x280002, VR.US, new int[]{3});
                attributes.setInt(2621696, VR.US, new int[]{8});
                attributes.setInt(2621697, VR.US, new int[]{8});
                attributes.setInt(2621698, VR.US, new int[]{7});
                attributes.setString(2621444, VR.CS, PhotometricInterpretation.RGB.name());
                attributes.setInt(2621699, VR.US, new int[]{0});
                attributes.setInt(2621446, VR.US, new int[]{0});
            }
        }
        return attributes;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        return ImageUtils.toType(image, 1);
    }

    public static BufferedImage toType(Image image, int n) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

