/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Objects;
import org.dcm4che3.data.PersonName;

public class PersonNameUtilities {
    public static PersonName parseFromReverseShort(String string) throws ParseException {
        PersonName personName;
        String[] stringArray;
        if (string == null) {
            return null;
        }
        String[] stringArray2 = string.split(",");
        if (stringArray2.length == 0) {
            return null;
        }
        if (stringArray2.length == 1) {
            stringArray = new String[3];
            personName = stringArray2[0].split(" ");
            int n = 0;
            while (n < ((String[])personName).length) {
                stringArray[n] = personName[n].trim();
                ++n;
            }
        } else if (stringArray2.length == 2) {
            personName = new ArrayList();
            String[] stringArray3 = stringArray2[1].split(" ");
            int n = stringArray3.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray3[n2];
                if (string2.length() > 0 && !string2.equals(" ")) {
                    personName.add(string2);
                }
                ++n2;
            }
            stringArray = new String[personName.size() + 1];
            stringArray[0] = stringArray2[0].trim();
            int n3 = 0;
            while (n3 < personName.size()) {
                stringArray[n3 + 1] = ((String)personName.get(n3)).trim();
                ++n3;
            }
        } else {
            throw new ParseException("Unknown format", 0);
        }
        personName = new PersonName();
        if (stringArray.length == 0) {
            return null;
        }
        if (stringArray.length > 0) {
            personName.set(PersonName.Component.FamilyName, stringArray[0]);
        }
        if (stringArray.length > 1) {
            personName.set(PersonName.Component.GivenName, stringArray[1]);
        }
        if (stringArray.length > 2) {
            personName.set(PersonName.Component.MiddleName, stringArray[2]);
        }
        return personName;
    }

    public static String personNameToHRReverseShort(PersonName personName) {
        if (personName == null) {
            return null;
        }
        StringBuilder stringBuilder = PersonNameUtilities.personNameToHRReverseShort(personName, PersonName.Group.Alphabetic, false);
        if (stringBuilder == null) {
            return null;
        }
        return stringBuilder.toString();
    }

    public static String personNameToHRReverseShortMultiLanguage(PersonName personName) {
        if (personName == null) {
            return null;
        }
        StringBuilder stringBuilder = PersonNameUtilities.personNameToHRReverseShort(personName, PersonName.Group.Alphabetic, true);
        if (stringBuilder == null) {
            return null;
        }
        return stringBuilder.toString();
    }

    private static StringBuilder personNameToHRReverseShort(PersonName personName, PersonName.Group group, boolean bl) {
        if (personName == null) {
            return null;
        }
        String string = personName.get(group, PersonName.Component.FamilyName);
        StringBuilder stringBuilder = new StringBuilder(32);
        if (string != null) {
            stringBuilder.append(string).append(',');
        }
        if ((string = personName.get(group, PersonName.Component.GivenName)) != null) {
            stringBuilder.append(' ').append(string).append(' ');
        }
        if ((string = personName.get(group, PersonName.Component.MiddleName)) != null) {
            stringBuilder.append(string).append(' ');
        }
        if (stringBuilder.length() < 1) {
            if (group != PersonName.Group.Alphabetic) {
                return null;
            }
            return new StringBuilder("N/A");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        if (bl && personName.get(PersonName.Group.Ideographic, PersonName.Component.FamilyName) != null && group == PersonName.Group.Alphabetic) {
            StringBuilder stringBuilder2 = PersonNameUtilities.personNameToHRReverseShort(personName, PersonName.Group.Ideographic, false);
            if (stringBuilder2 != null) {
                stringBuilder.append('(').append((CharSequence)stringBuilder2).append(')');
            }
            if ((stringBuilder2 = PersonNameUtilities.personNameToHRReverseShort(personName, PersonName.Group.Phonetic, false)) != null) {
                stringBuilder.append('[').append((CharSequence)stringBuilder2).append(']');
            }
        }
        return stringBuilder;
    }

    public static String personNameToHRReverse(PersonName personName) {
        if (personName == null) {
            return null;
        }
        StringBuilder stringBuilder = PersonNameUtilities.personNameToHRReverse(personName, PersonName.Group.Alphabetic);
        if (stringBuilder == null) {
            return "";
        }
        return stringBuilder.toString();
    }

    private static StringBuilder personNameToHRReverse(PersonName personName, PersonName.Group group) {
        if (personName == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        String string = personName.get(group, PersonName.Component.FamilyName);
        if (string != null) {
            stringBuilder.append(string).append(',');
        }
        if ((string = personName.get(group, PersonName.Component.GivenName)) != null) {
            stringBuilder.append(' ').append(string).append(' ');
        }
        if ((string = personName.get(group, PersonName.Component.MiddleName)) != null) {
            stringBuilder.append(string).append(' ');
        }
        if ((string = personName.get(group, PersonName.Component.NamePrefix)) != null) {
            stringBuilder.append(string).append(' ');
        }
        if ((string = personName.get(group, PersonName.Component.NameSuffix)) != null) {
            stringBuilder.append(string).append(' ');
        }
        if (stringBuilder.length() < 1) {
            if (group != PersonName.Group.Alphabetic) {
                return null;
            }
            return new StringBuilder("N/A");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        if (personName.get(PersonName.Group.Ideographic, PersonName.Component.FamilyName) != null && group == PersonName.Group.Alphabetic) {
            StringBuilder stringBuilder2 = PersonNameUtilities.personNameToHRReverse(personName, PersonName.Group.Ideographic);
            if (stringBuilder2 != null) {
                stringBuilder.append('(').append((CharSequence)stringBuilder2).append(')');
            }
            if ((stringBuilder2 = PersonNameUtilities.personNameToHRReverse(personName, PersonName.Group.Phonetic)) != null) {
                stringBuilder.append('[').append((CharSequence)stringBuilder2).append(']');
            }
        }
        return stringBuilder;
    }

    public static String personNameToHR(PersonName personName) {
        return Objects.toString(PersonNameUtilities.personNameToHR(personName, PersonName.Group.Alphabetic));
    }

    private static StringBuilder personNameToHR(PersonName personName, PersonName.Group group) {
        if (personName == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        String string = personName.get(group, PersonName.Component.NamePrefix);
        if (string != null) {
            stringBuilder.append(string).append(' ');
        }
        if ((string = personName.get(group, PersonName.Component.GivenName)) != null) {
            stringBuilder.append(string).append(' ');
        }
        if ((string = personName.get(group, PersonName.Component.MiddleName)) != null) {
            stringBuilder.append(string).append(' ');
        }
        if ((string = personName.get(group, PersonName.Component.FamilyName)) != null) {
            stringBuilder.append(string).append(' ');
        }
        if ((string = personName.get(group, PersonName.Component.NameSuffix)) != null) {
            stringBuilder.append(string).append(' ');
        }
        if (stringBuilder.length() < 1) {
            if (group != PersonName.Group.Alphabetic) {
                return null;
            }
            return new StringBuilder("N/A");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        if (personName.get(PersonName.Group.Ideographic, PersonName.Component.FamilyName) != null && group == PersonName.Group.Alphabetic) {
            StringBuilder stringBuilder2 = PersonNameUtilities.personNameToHR(personName, PersonName.Group.Ideographic);
            if (stringBuilder2 != null) {
                stringBuilder.append('=').append((CharSequence)stringBuilder2);
            }
            if ((stringBuilder2 = PersonNameUtilities.personNameToHR(personName, PersonName.Group.Phonetic)) != null) {
                stringBuilder.append('=').append((CharSequence)stringBuilder2);
            }
        }
        return stringBuilder;
    }

    public static String personNameToHRShort(PersonName personName) {
        return Objects.toString(PersonNameUtilities.personNameToHRShort(personName, PersonName.Group.Alphabetic));
    }

    private static StringBuilder personNameToHRShort(PersonName personName, PersonName.Group group) {
        if (personName == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        String string = personName.get(group, PersonName.Component.FamilyName);
        if (string != null) {
            stringBuilder.append(string).append(',');
        }
        if ((string = personName.get(group, PersonName.Component.GivenName)) != null) {
            stringBuilder.append(' ').append(string).append(' ');
        }
        if (personName.get(PersonName.Group.Ideographic, PersonName.Component.FamilyName) != null && group == PersonName.Group.Alphabetic) {
            StringBuilder stringBuilder2 = PersonNameUtilities.personNameToHRShort(personName, PersonName.Group.Ideographic);
            if (stringBuilder2 != null) {
                stringBuilder.append('=').append((CharSequence)stringBuilder2);
            }
            if ((stringBuilder2 = PersonNameUtilities.personNameToHRShort(personName, PersonName.Group.Phonetic)) != null) {
                stringBuilder.append('=').append((CharSequence)stringBuilder2);
            }
        }
        return stringBuilder;
    }
}

