/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicomize.impl;

import com.agfa.pacs.base.util.ImageUtils;
import com.agfa.pacs.data.dicomize.FileImportException;
import com.agfa.pacs.data.dicomize.IFileMetadataExtractor;
import com.agfa.pacs.data.dicomize.IFileTypeImporter;
import com.agfa.pacs.data.dicomize.IImportObject;
import com.agfa.pacs.data.dicomize.IImportedObject;
import com.agfa.pacs.data.dicomize.MetadataExtractorException;
import com.agfa.pacs.data.dicomize.impl.DefaultImportedObject;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImageImporter
implements IFileTypeImporter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractImageImporter.class);
    private static final String SOPClassUID = "1.2.840.10008.5.1.4.1.1.7.4";
    private static final String transferSyntaxUID = "1.2.840.10008.1.2";
    private static Map<String, IFileMetadataExtractor> metadataExtractors = Collections.synchronizedMap(new HashMap());

    public static void addFileMetadataExtractor(IFileMetadataExtractor iFileMetadataExtractor) {
        for (String string : iFileMetadataExtractor.getListOfSupportedMimeTypes()) {
            metadataExtractors.put(string, iFileMetadataExtractor);
        }
    }

    public static IFileMetadataExtractor getMetadataExtractor(String string) {
        return metadataExtractors.get(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IImportedObject dicomize(Attributes attributes, IImportObject iImportObject, Properties properties) throws FileImportException {
        DefaultImportedObject defaultImportedObject;
        InputStream inputStream = null;
        try {
            inputStream = iImportObject.openInputStream();
            attributes.setString(0x700080, VR.CS, iImportObject.getName());
            Date date = iImportObject.getDate();
            attributes.setDate(2251950138064947L, date);
            attributes.setDate(2251945843097650L, date);
            BufferedImage bufferedImage = this.readInputStream(inputStream, attributes);
            IFileMetadataExtractor iFileMetadataExtractor = metadataExtractors.get(iImportObject.getMimeType());
            if (iFileMetadataExtractor != null) {
                this.getFileMetaData(iImportObject, attributes);
            }
            defaultImportedObject = new DefaultImportedObject(attributes, bufferedImage);
        }
        catch (IOException iOException) {
            try {
                throw new FileImportException("Could not read file " + iImportObject.getName());
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    LOG.error("Failed to close the input stream(s)");
                }
                throw throwable;
            }
        }
        try {
            if (inputStream == null) return defaultImportedObject;
            inputStream.close();
            return defaultImportedObject;
        }
        catch (IOException iOException) {
            LOG.error("Failed to close the input stream(s)");
        }
        return defaultImportedObject;
    }

    protected void getFileMetaData(IImportObject iImportObject, Attributes attributes) throws IOException {
        IFileMetadataExtractor iFileMetadataExtractor = metadataExtractors.get(iImportObject.getMimeType());
        if (iFileMetadataExtractor != null) {
            try {
                iFileMetadataExtractor.getFileMetaData(iImportObject, attributes);
            }
            catch (MetadataExtractorException metadataExtractorException) {
                LOG.warn("Error extracting Metadata from file", (Throwable)metadataExtractorException);
            }
        }
    }

    private BufferedImage readInputStream(InputStream inputStream, Attributes attributes) throws IOException {
        BufferedImage bufferedImage = this.readImage(inputStream);
        attributes.setInt(0x280008, VR.IS, new int[]{1});
        attributes.addAll(ImageUtils.readImageAttributes(bufferedImage));
        attributes.setString(131088, VR.UI, transferSyntaxUID);
        attributes.setString(7340161, VR.LO, "File import");
        attributes.setString(2629904, VR.CS, "01");
        return bufferedImage;
    }

    protected abstract BufferedImage readImage(InputStream var1) throws IOException;

    @Override
    public String getSOPClassUID() {
        return SOPClassUID;
    }

    @Override
    public String getModality() {
        return "OT";
    }

    @Override
    public String getTransferSyntaxUID() {
        return transferSyntaxUID;
    }
}

