/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicomize.impl;

import com.agfa.pacs.data.dicomize.FileImportException;
import com.agfa.pacs.data.dicomize.IFileTypeImporter;
import com.agfa.pacs.data.dicomize.IImportObject;
import com.agfa.pacs.data.dicomize.IImportedObject;
import com.agfa.pacs.data.dicomize.impl.DefaultImportedObject;
import com.agfa.pacs.data.shared.dicom.YesNo;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.VR;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CDAImporter
implements IFileTypeImporter {
    public static final String TYPE = "CDA";
    private static final String SOPClassUID = "1.2.840.10008.5.1.4.1.1.104.2";
    private static final String transferSyntaxUID = "1.2.840.10008.1.2.1";
    private static final Set<String> mimeTypes = Collections.singleton("application/x-hl7-cda-level-one+xml");

    @Override
    public boolean canHandleMimeType(String string) {
        return mimeTypes.contains(StringUtils.lowerCase((String)string, (Locale)Locale.ENGLISH));
    }

    @Override
    public IImportedObject dicomize(Attributes attributes, IImportObject iImportObject, Properties properties) throws FileImportException {
        try {
            String[] stringArray = iImportObject.getName().split("\\.");
            if (iImportObject.getLength() > 0x6400000L) {
                throw new FileImportException("File too large" + iImportObject.getLength());
            }
            Date date = iImportObject.getDate();
            attributes.setString(4325394, VR.LO, "text/xml");
            attributes.setString(4325392, VR.ST, stringArray[0]);
            attributes.setString(0x700080, VR.CS, iImportObject.getName());
            attributes.setDate(2251950138064947L, date);
            attributes.setDate(2251945843097650L, date);
            attributes.setString(131088, VR.UI, transferSyntaxUID);
            attributes.setString(524384, VR.CS, this.getModality());
            attributes.setString(2622209, VR.CS, YesNo.No.dicom());
            attributes.setBytes(4325393, VR.OB, iImportObject.getByteArray());
            CDAImporter.parseAndInheritFromCDA(attributes, iImportObject);
            return new DefaultImportedObject(attributes);
        }
        catch (IOException iOException) {
            throw new FileImportException("Could not read file" + iImportObject.getName());
        }
        catch (Exception exception) {
            FileImportException fileImportException = new FileImportException(exception.getMessage());
            fileImportException.initCause(exception);
            throw fileImportException;
        }
    }

    @Override
    public String getModality() {
        return "SR";
    }

    @Override
    public String getSOPClassUID() {
        return SOPClassUID;
    }

    @Override
    public String getTransferSyntaxUID() {
        return transferSyntaxUID;
    }

    private static void parseAndInheritFromCDA(Attributes attributes, IImportObject iImportObject) throws Exception {
        NodeList nodeList;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(iImportObject.openInputStream());
        document.getDocumentElement().normalize();
        NodeList nodeList2 = document.getElementsByTagName("ClinicalDocument");
        if (nodeList2 != null && nodeList2.getLength() > 0 && (nodeList = nodeList2.item(0).getChildNodes()) != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                NamedNodeMap namedNodeMap;
                Node node = nodeList.item(n);
                String string = node.getLocalName();
                if ("title".equals(string)) {
                    attributes.setString(4325392, VR.ST, node.getNodeValue());
                } else if ("code".equals(string)) {
                    namedNodeMap = node.getAttributes();
                    attributes.newSequence(4235331, 1).add(new Code(namedNodeMap.getNamedItem("code").getNodeValue(), namedNodeMap.getNamedItem("codeSystemName").getNodeValue(), null, namedNodeMap.getNamedItem("displayName").getNodeValue()).toItem());
                } else if ("id".equals(string)) {
                    namedNodeMap = node.getAttributes();
                    StringBuilder stringBuilder = new StringBuilder(namedNodeMap.getNamedItem("root").getNodeValue());
                    Node node2 = namedNodeMap.getNamedItem("extension");
                    if (node2 != null) {
                        stringBuilder.append("^").append(node2.getNodeValue());
                    }
                    attributes.setString(4251649, VR.ST, stringBuilder.toString());
                }
                ++n;
            }
        }
    }

    @Override
    public String getName() {
        return TYPE;
    }
}

