/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicomize.impl;

import com.agfa.pacs.base.util.ImageUtils;
import com.agfa.pacs.data.dicomize.IImportedObject;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultImportedObject
implements IImportedObject {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultImportedObject.class);
    public static final int BUFFERED_IMAGE_TYPE = 2;
    private Attributes object;
    private BufferedImage[] images;

    public DefaultImportedObject(Attributes attributes) {
        this.object = attributes;
    }

    public DefaultImportedObject(Attributes attributes, BufferedImage bufferedImage) {
        this.object = attributes;
        this.images = new BufferedImage[]{bufferedImage};
    }

    public DefaultImportedObject(Attributes attributes, BufferedImage[] bufferedImageArray) {
        this.object = attributes;
        this.images = bufferedImageArray;
        int n = 0;
        while (n < bufferedImageArray.length) {
            if (bufferedImageArray[n].getType() != 2) {
                bufferedImageArray[n] = ImageUtils.toType(bufferedImageArray[n], 2);
            }
            ++n;
        }
    }

    @Override
    public Attributes toAttribute() {
        if (this.images == null) {
            return new Attributes(this.object);
        }
        try {
            Attributes attributes = new Attributes(this.object);
            attributes.addAll(ImageUtils.readImageAttributes(this.images[0]));
            int n = attributes.getInt(2621456, 0) * attributes.getInt(2621457, 0) * this.images.length;
            Throwable throwable = null;
            Object var4_6 = null;
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);){
                this.encodeData(byteArrayOutputStream);
                attributes.setBytes(2145386512, VR.OB, byteArrayOutputStream.toByteArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return attributes;
        }
        catch (Exception exception) {
            LOG.error("Could not serialize images", (Throwable)exception);
            throw new IllegalStateException(exception);
        }
    }

    private long encodeData(OutputStream outputStream) throws IOException {
        long l = 0L;
        BufferedImage[] bufferedImageArray = this.images;
        int n = this.images.length;
        int n2 = 0;
        while (n2 < n) {
            BufferedImage bufferedImage = bufferedImageArray[n2];
            byte[] byArray = DefaultImportedObject.toDicomByteArray(bufferedImage);
            StreamUtils.copy((InputStream)new ByteArrayInputStream(byArray), (OutputStream)outputStream);
            l += (long)byArray.length;
            ++n2;
        }
        return l;
    }

    public static byte[] toDicomByteArray(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 10: {
                return ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            }
            case 1: 
            case 2: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                byte[] byArray = new byte[nArray.length * 3];
                int n = 0;
                int[] nArray2 = nArray;
                int n2 = nArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = nArray2[n3];
                    byArray[n] = (byte)(n4 >>> 16 & 0xFF);
                    byArray[++n] = (byte)(n4 >>> 8 & 0xFF);
                    byArray[++n] = (byte)(n4 & 0xFF);
                    ++n;
                    ++n3;
                }
                return byArray;
            }
        }
        return DefaultImportedObject.toDicomByteArray(ImageUtils.toType(bufferedImage, 2));
    }

    @Override
    public Attributes getHeader() {
        return this.object;
    }

    @Override
    public BufferedImage[] getImages() {
        return this.images;
    }

    @Override
    public BufferedImage getImage() {
        if (this.images == null) {
            return null;
        }
        return this.images[0];
    }

    @Override
    public void setImages(BufferedImage[] bufferedImageArray) {
        this.images = bufferedImageArray;
    }
}

