/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicomize.impl;

import com.agfa.pacs.data.dicomize.IImportObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import org.dcm4che3.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileImportObject
implements IImportObject {
    private static final Logger LOG = LoggerFactory.getLogger(FileImportObject.class);
    private final File file;
    private final String mimeType;

    public FileImportObject(File file, String string) {
        this.file = file;
        this.mimeType = string;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return Files.newInputStream(this.file.toPath(), new OpenOption[0]);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public byte[] getByteArray() {
        byte[] byArray = new byte[(int)this.getLength()];
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = Files.newInputStream(this.file.toPath(), new OpenOption[0]);){
                StreamUtils.readFully((InputStream)inputStream, (byte[])byArray, (int)0, (int)byArray.length);
                return byArray;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            LOG.error("Could not find appropriate file", (Throwable)iOException);
            throw new IllegalArgumentException(iOException);
        }
    }

    @Override
    public Date getDate() {
        return new Date(this.file.lastModified());
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }
}

