/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicomize.impl;

import com.agfa.pacs.data.dicomize.impl.AbstractImageImporter;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class JpegImageImporter
extends AbstractImageImporter {
    private static final String TYPE = "JPEG";
    private static final Set<String> mimeTypes = Collections.singleton("image/jpeg");

    @Override
    public boolean canHandleMimeType(String string) {
        return mimeTypes.contains(StringUtils.lowerCase((String)string, (Locale)Locale.ENGLISH));
    }

    @Override
    protected BufferedImage readImage(InputStream inputStream) throws IOException {
        try {
            JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)inputStream);
            BufferedImage bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
            return bufferedImage;
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public String getName() {
        return TYPE;
    }
}

