/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicomize.impl;

import com.agfa.pacs.data.dicomize.FileImportException;
import com.agfa.pacs.data.dicomize.IFileTypeImporter;
import com.agfa.pacs.data.dicomize.IImportObject;
import com.agfa.pacs.data.dicomize.IImportedObject;
import com.agfa.pacs.data.dicomize.impl.DefaultImportedObject;
import com.agfa.pacs.data.shared.dicom.YesNo;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class PDFImporter
implements IFileTypeImporter {
    public static final String TYPE = "PDF";
    private static final String SOPClassUID = "1.2.840.10008.5.1.4.1.1.104.1";
    private static final String transferSyntaxUID = "1.2.840.10008.1.2.1";
    private static final Set<String> mimeTypes = Collections.singleton("application/pdf");

    @Override
    public boolean canHandleMimeType(String string) {
        return mimeTypes.contains(StringUtils.lowerCase((String)string, (Locale)Locale.ENGLISH));
    }

    @Override
    public IImportedObject dicomize(Attributes attributes, IImportObject iImportObject, Properties properties) throws FileImportException {
        String string = iImportObject.getName();
        if (string == null) {
            string = "";
        }
        String[] stringArray = string.split("\\.");
        if (iImportObject.getLength() > 0x6400000L) {
            throw new FileImportException("File too large" + iImportObject.getLength());
        }
        attributes.setString(4325394, VR.LO, iImportObject.getMimeType());
        attributes.setString(4325392, VR.ST, stringArray[0]);
        attributes.setString(0x700080, VR.CS, iImportObject.getName());
        Date date = iImportObject.getDate();
        attributes.setDate(2251950138064947L, date);
        attributes.setDate(2251945843097650L, date);
        byte[] byArray = iImportObject.getByteArray();
        attributes.setDouble("TIANI", 7405670, VR.DS, new double[]{byArray.length});
        return this.setContent(byArray, attributes);
    }

    private IImportedObject setContent(byte[] byArray, Attributes attributes) {
        attributes.setString(131088, VR.UI, transferSyntaxUID);
        attributes.setBytes(4325393, VR.OB, byArray);
        attributes.setString(524384, VR.CS, this.getModality());
        attributes.setString(2622209, VR.CS, YesNo.Yes.dicom());
        attributes.newSequence(4235331, 0);
        return new DefaultImportedObject(attributes);
    }

    @Override
    public String getModality() {
        return "SR";
    }

    @Override
    public String getSOPClassUID() {
        return SOPClassUID;
    }

    @Override
    public String getTransferSyntaxUID() {
        return transferSyntaxUID;
    }

    @Override
    public String getName() {
        return TYPE;
    }
}

