/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicomize.impl;

import com.agfa.pacs.data.dicomize.IImportObject;
import com.agfa.pacs.data.dicomize.ISeriesAttributesProvider;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.UIDUtils;

public class PreparedSeriesAttributesProvider
implements ISeriesAttributesProvider {
    private final Map<IImportObject, Attributes> file2series;
    private final Map<Attributes, ActualSeries> preparedSeries2actualSeries = new IdentityHashMap<Attributes, ActualSeries>();
    private int seriesNumber = 1;

    public PreparedSeriesAttributesProvider(Map<IImportObject, Attributes> map) {
        this.file2series = map;
    }

    @Override
    public synchronized Attributes provideAttributes(IImportObject iImportObject, String string) {
        Attributes attributes = this.file2series.get(iImportObject);
        if (attributes == null) {
            throw new IllegalArgumentException("No prepared series attributes for file " + iImportObject.getName());
        }
        ActualSeries actualSeries = this.preparedSeries2actualSeries.get(attributes);
        if (actualSeries == null) {
            actualSeries = new ActualSeries(attributes);
            this.preparedSeries2actualSeries.put(attributes, actualSeries);
        }
        Attributes attributes2 = actualSeries.provideActualSeriesForModality(string);
        return attributes2;
    }

    private class ActualSeries {
        private final Attributes preparedSeries;
        private final Map<String, Attributes> actualSeries = new HashMap<String, Attributes>();
        private final Map<String, Integer> instanceNumbers = new HashMap<String, Integer>();

        public ActualSeries(Attributes attributes) {
            this.preparedSeries = attributes;
        }

        public Attributes provideActualSeriesForModality(String string) {
            Attributes attributes = this.actualSeries.get(string);
            if (attributes == null) {
                attributes = new Attributes(this.preparedSeries);
                attributes.setString(524384, VR.CS, string);
                attributes.setInt(0x200011, VR.IS, new int[]{PreparedSeriesAttributesProvider.this.seriesNumber});
                PreparedSeriesAttributesProvider preparedSeriesAttributesProvider = PreparedSeriesAttributesProvider.this;
                preparedSeriesAttributesProvider.seriesNumber = preparedSeriesAttributesProvider.seriesNumber + 1;
                if (!this.actualSeries.isEmpty() || !attributes.contains(0x20000E)) {
                    attributes.setString(0x20000E, VR.UI, UIDUtils.createUID());
                }
                this.actualSeries.put(string, attributes);
                this.instanceNumbers.put(string, 0);
            }
            Attributes attributes2 = new Attributes(attributes);
            int n = this.instanceNumbers.get(string) + 1;
            this.instanceNumbers.put(string, n);
            attributes2.setInt(2097171, VR.IS, new int[]{n});
            return attributes2;
        }
    }
}

