/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicomize.impl;

import com.agfa.pacs.data.dicomize.IImportObject;
import com.agfa.pacs.data.dicomize.impl.DefaultImportedObject;
import com.agfa.pacs.data.dicomize.impl.InputStreamBulkData;
import java.io.File;
import java.util.Arrays;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.Value;

public class VideoImportedObject
extends DefaultImportedObject {
    private static final int CHUNK_SIZE = 0xA00000;
    private File videoFile = null;
    private IImportObject importObject = null;
    private long length;

    public VideoImportedObject(Attributes attributes, IImportObject iImportObject) {
        super(attributes);
        this.videoFile = iImportObject.getFile();
        this.length = iImportObject.getLength();
        if (this.videoFile == null) {
            this.importObject = iImportObject;
        }
    }

    @Override
    public Attributes toAttribute() {
        Attributes attributes = super.toAttribute();
        int n = (int)Math.ceil((double)this.length / 1.048576E7);
        int n2 = (int)Math.floor((double)this.length / 1.048576E7);
        long[] lArray = new long[n + 1];
        int[] nArray = new int[n + 1];
        Arrays.fill(nArray, 0xA00000);
        long l = 0L;
        lArray[0] = 0L;
        nArray[0] = 0;
        int n3 = 0;
        while (n3 < n) {
            lArray[n3 + 1] = l;
            l += 0xA00000L;
            ++n3;
        }
        if (n2 != n) {
            nArray[n] = (int)(this.length - (long)(n2 * 0xA00000));
        }
        if (this.videoFile != null) {
            String string = this.videoFile.toURI().toString();
            attributes.setValue(2145386512, VR.OB, (Object)new BulkData(string, lArray, nArray, false).toFragments(null, 2145386512, VR.OB));
        } else {
            Fragments fragments = new Fragments(null, 2145386512, VR.OB, false, nArray.length);
            int n4 = 0;
            while (n4 < nArray.length) {
                fragments.add(nArray[n4] == 0 ? Value.NULL : new InputStreamBulkData(this.importObject, lArray[n4], nArray[n4]));
                ++n4;
            }
            attributes.setValue(2145386512, VR.OB, (Object)fragments);
        }
        return attributes;
    }
}

