/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicomize.impl;

import com.agfa.pacs.data.dicomize.FileImportException;
import com.agfa.pacs.data.dicomize.IFileMetadataExtractor;
import com.agfa.pacs.data.dicomize.IFileTypeImporter;
import com.agfa.pacs.data.dicomize.IImportObject;
import com.agfa.pacs.data.dicomize.IImportedObject;
import com.agfa.pacs.data.dicomize.MetadataExtractorException;
import com.agfa.pacs.data.dicomize.impl.AbstractImageImporter;
import com.agfa.pacs.data.dicomize.impl.VideoImportedObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.image.PhotometricInterpretation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoImporter
implements IFileTypeImporter {
    private static final Logger LOG = LoggerFactory.getLogger(VideoImporter.class);
    public static final String TYPE = "VIDEO";
    private final Set<String> mimeTypes = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("video/avi", "video/quicktime", "video/mpeg", "video/dvd", "video/mp4", "video/mp2t")));
    private static final String transferSyntaxUID = "1.2.840.10008.1.2.4.100";

    @Override
    public boolean canHandleMimeType(String string) {
        return this.mimeTypes.contains(StringUtils.lowerCase((String)string, (Locale)Locale.ENGLISH));
    }

    protected void setDefaultVideoAttributes(Attributes attributes) {
        attributes.setInt(0x280008, VR.IS, new int[]{1});
        attributes.setDouble(1577059, VR.DS, new double[]{40.0});
        attributes.setInt(1572928, VR.IS, new int[]{25});
        attributes.setInt(2621449, VR.AT, new int[]{1577059});
        attributes.setString(131088, VR.UI, transferSyntaxUID);
        attributes.setInt(0x280002, VR.US, new int[]{3});
        attributes.setString(2621444, VR.CS, PhotometricInterpretation.YBR_PARTIAL_422.name());
        attributes.setInt(2621696, VR.US, new int[]{8});
        attributes.setInt(2621697, VR.US, new int[]{8});
        attributes.setInt(2621698, VR.US, new int[]{7});
        attributes.setInt(2621699, VR.US, new int[]{0});
        attributes.setInt(2621456, VR.US, new int[]{576});
        attributes.setInt(2621457, VR.US, new int[]{720});
        attributes.setInt(2621446, VR.US, new int[]{0});
    }

    @Override
    public IImportedObject dicomize(Attributes attributes, IImportObject iImportObject, Properties properties) throws FileImportException {
        attributes.setString(0x700080, VR.CS, iImportObject.getName());
        attributes.setDate(524323, VR.DA, new Date[]{iImportObject.getDate()});
        this.setDefaultVideoAttributes(attributes);
        this.getFileMetaData(iImportObject, attributes);
        return new VideoImportedObject(attributes, iImportObject);
    }

    protected void getFileMetaData(IImportObject iImportObject, Attributes attributes) {
        IFileMetadataExtractor iFileMetadataExtractor = AbstractImageImporter.getMetadataExtractor(iImportObject.getMimeType());
        if (iFileMetadataExtractor != null) {
            try {
                iFileMetadataExtractor.getFileMetaData(iImportObject, attributes);
            }
            catch (MetadataExtractorException metadataExtractorException) {
                LOG.warn("Error extracting Metadata from file", (Throwable)metadataExtractorException);
            }
        }
    }

    @Override
    public String getModality() {
        return "ES";
    }

    @Override
    public String getSOPClassUID() {
        return "1.2.840.10008.5.1.4.1.1.77.1.1.1";
    }

    @Override
    public String getTransferSyntaxUID() {
        return transferSyntaxUID;
    }

    @Override
    public String getName() {
        return TYPE;
    }
}

