/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.dmcdw;

import com.agfa.pacs.data.export.dmcdw.core.DicomMediaCreationClient;
import com.agfa.pacs.data.export.dmcdw.core.DicomMediaCreationStatus;
import com.agfa.pacs.data.export.dmcdw.core.ExecutionStatus;
import com.agfa.pacs.data.export.dmcdw.core.ExecutionStatusInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMCSCreationImpl {
    private static final Logger log = LoggerFactory.getLogger(DMCSCreationImpl.class);
    private static final int REFRESH_TIME_IN_MS = 10000;
    private IDMCSCreationListener advancer;
    private final DicomMediaCreationClient client;
    private final int copies;
    private final String dmcsInstance;
    private String message;

    public DMCSCreationImpl(String string, DicomMediaCreationClient dicomMediaCreationClient, int n) {
        this.client = dicomMediaCreationClient;
        this.copies = n;
        this.dmcsInstance = string;
        this.message = "Media Creation on " + dicomMediaCreationClient.getDicomNodeName();
    }

    public String getInfo() {
        return this.message;
    }

    public boolean execute() {
        ExecutionStatus executionStatus;
        int n = -1;
        this.message = null;
        this.advancer.setProgress(0.02);
        do {
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {}
            if (this.advancer.isCancelled()) {
                this.message = "";
                while (true) {
                    int n2;
                    if ((n2 = this.client.cancelCreation(this.dmcsInstance)) == 0 || n2 == 513) {
                        return false;
                    }
                    if (n2 == 515 || n2 == -1) {
                        this.message = "DMCS Could not cancel";
                        return false;
                    }
                    try {
                        Thread.sleep(3333L);
                    }
                    catch (Exception exception) {}
                }
            }
            DicomMediaCreationStatus dicomMediaCreationStatus = this.client.statusOfCreation(this.dmcsInstance);
            if (dicomMediaCreationStatus != null) {
                int n3;
                ExecutionStatusInfo executionStatusInfo = dicomMediaCreationStatus.getExecutionStatusInfo();
                if (executionStatusInfo != null) {
                    this.message = executionStatusInfo.toString();
                }
                if ((n3 = dicomMediaCreationStatus.getTotalNumberOfPiecesOfMediaCreated()) < 0) {
                    n3 = 0;
                }
                if (n != n3) {
                    double d = (double)n3 / (double)this.copies;
                    if (d < 0.001) {
                        d = 1.0 / (double)(this.copies * 2);
                    }
                    this.advancer.setProgress(d);
                    n = n3;
                }
                executionStatus = dicomMediaCreationStatus.getExecutionStatus();
            } else {
                executionStatus = ExecutionStatus.Failure;
            }
            if (executionStatus != ExecutionStatus.Failure) continue;
            this.message = "DMCS Status Failed";
            log.error("DMCS returned failed");
            this.advancer.setProgress(1.0);
            return false;
        } while (executionStatus != ExecutionStatus.Done);
        log.info("DMCS Done");
        this.message = "Done";
        this.advancer.setProgress(1.0);
        return true;
    }

    public void setListener(IDMCSCreationListener iDMCSCreationListener) {
        this.advancer = iDMCSCreationListener;
    }

    public String getUID() {
        return this.dmcsInstance;
    }

    public static interface IDMCSCreationListener {
        public void setProgress(double var1);

        public boolean isCancelled();
    }
}

