/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.dmcdw;

import com.agfa.pacs.data.export.dmcdw.DMCSCreationImpl;
import com.agfa.pacs.data.export.dmcdw.IDicomMediaCreationNServiceSCU;
import com.agfa.pacs.data.export.dmcdw.core.DicomMediaCreationClient;
import com.agfa.pacs.data.export.dmcdw.core.DicomMediaCreationInitiation;
import com.agfa.pacs.data.export.dmcdw.core.DicomMediaCreationRequest;
import com.agfa.pacs.data.export.dmcdw.core.RequestPriority;
import java.util.Properties;
import org.dcm4che3.data.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaCreationImpl {
    private static final Logger log = LoggerFactory.getLogger(MediaCreationImpl.class);
    public static final String DICOM_MEDIA_CREATION_REQUEST = "DICOM_MEDIA_CREATION_REQUEST";
    public static final String NUMBER_OF_COPIES = "DICOM_MEDIA_CREATION_NUMBER_OF_COPIES";
    public static final String PRIORITY = "DICOM_MEDIA_CREATION_PRIORITY";
    private DicomMediaCreationRequest request = null;
    private DicomMediaCreationClient client = null;
    private int copiesCount = 1;
    private int requestPriority = 1;

    public void cleanUp() {
        this.request = null;
        this.client = null;
    }

    public DMCSCreationImpl finishProcessing() {
        String string = this.client.createMediaCreationInstance(this.request);
        if (string == null) {
            log.error("Creation failed");
            throw new IllegalArgumentException("Connection to DMCS failed");
        }
        DicomMediaCreationInitiation dicomMediaCreationInitiation = new DicomMediaCreationInitiation();
        dicomMediaCreationInitiation.setNumberOfCopies(this.copiesCount);
        dicomMediaCreationInitiation.setRequestPriority(MediaCreationImpl.getPriorityName(this.requestPriority));
        boolean bl = this.client.initiateCreation(string, dicomMediaCreationInitiation);
        if (!bl) {
            log.error("Creation failed: {}", (Object)bl);
            throw new IllegalArgumentException("SendToDMCS failed");
        }
        return new DMCSCreationImpl(string, this.client, this.copiesCount);
    }

    private static RequestPriority getPriorityName(int n) {
        if (n == 0) {
            return RequestPriority.Low;
        }
        if (n == 2) {
            return RequestPriority.High;
        }
        return RequestPriority.Medium;
    }

    public void prepareProcessing(IDicomMediaCreationNServiceSCU iDicomMediaCreationNServiceSCU, Properties properties) {
        this.client = new DicomMediaCreationClient(iDicomMediaCreationNServiceSCU);
        if (!properties.containsKey(DICOM_MEDIA_CREATION_REQUEST)) {
            throw new IllegalArgumentException("No request specified");
        }
        this.request = (DicomMediaCreationRequest)properties.get(DICOM_MEDIA_CREATION_REQUEST);
        if (properties.containsKey(NUMBER_OF_COPIES)) {
            this.copiesCount = (Integer)properties.get(NUMBER_OF_COPIES);
        }
        if (properties.containsKey(PRIORITY)) {
            this.requestPriority = (Integer)properties.get(PRIORITY);
        }
    }

    public Object process(Object object) {
        if (object instanceof Attributes) {
            Attributes attributes = (Attributes)object;
            this.request.addReferencedImage(attributes, null);
            return null;
        }
        throw new IllegalArgumentException("Wrong input type");
    }
}

