/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.dmcdw.core;

import com.agfa.pacs.data.export.dmcdw.IDicomMediaCreationNServiceSCU;
import com.agfa.pacs.data.export.dmcdw.core.DicomMediaCreationInitiation;
import com.agfa.pacs.data.export.dmcdw.core.DicomMediaCreationRequest;
import com.agfa.pacs.data.export.dmcdw.core.DicomMediaCreationStatus;
import org.dcm4che3.data.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicomMediaCreationClient {
    public static final int CancelStatusError = -1;
    public static final int CancelStatusSucceeded = 0;
    public static final int CancelStatusAlreadyCompleted = 513;
    public static final int CancelStatusCreationInProgress = 514;
    public static final int CancelStatusDenied = 515;
    private static final Logger log = LoggerFactory.getLogger(DicomMediaCreationClient.class);
    private final IDicomMediaCreationNServiceSCU nService;

    public DicomMediaCreationClient(IDicomMediaCreationNServiceSCU iDicomMediaCreationNServiceSCU) {
        this.nService = iDicomMediaCreationNServiceSCU;
    }

    public String getDicomNodeName() {
        return this.nService.getNodeName();
    }

    private void connect() {
        try {
            if (!this.nService.isConnected()) {
                this.nService.connect();
            }
        }
        catch (Exception exception) {
            log.error("Connecting to media creation server failed", (Throwable)exception);
        }
    }

    private void disconnect() {
        try {
            this.nService.close();
        }
        catch (Exception exception) {
            log.error("Disconnecting from media creation server failed", (Throwable)exception);
        }
    }

    public String createMediaCreationInstance(DicomMediaCreationRequest dicomMediaCreationRequest) {
        try {
            this.connect();
            String string = this.nService.nCreateInstance(dicomMediaCreationRequest.toDataset());
            return string;
        }
        catch (Exception exception) {
            log.error("Creating media creation instance failed", (Throwable)exception);
            return null;
        }
        finally {
            this.disconnect();
        }
    }

    public boolean initiateCreation(String string, DicomMediaCreationInitiation dicomMediaCreationInitiation) {
        try {
            this.connect();
            boolean bl = this.nService.nActionInitiate(dicomMediaCreationInitiation.toDataset(), string);
            return bl;
        }
        catch (Exception exception) {
            log.error("Initiating meda creation failed", (Throwable)exception);
            return false;
        }
        finally {
            this.disconnect();
        }
    }

    public int cancelCreation(String string) {
        try {
            this.connect();
            this.nService.nActionCancel(string);
            int n = this.nService.getLastStatus();
            return n;
        }
        catch (Exception exception) {
            log.error("Cancelling media creation failed", (Throwable)exception);
            return -1;
        }
        finally {
            this.disconnect();
        }
    }

    public DicomMediaCreationStatus statusOfCreation(String string) {
        try {
            this.connect();
            Attributes attributes = this.nService.nGetStatus(string);
            if (attributes == null) {
                return null;
            }
            DicomMediaCreationStatus dicomMediaCreationStatus = new DicomMediaCreationStatus(attributes);
            return dicomMediaCreationStatus;
        }
        catch (Exception exception) {
            log.error("Querying the media creation status failed", (Throwable)exception);
            return null;
        }
        finally {
            this.disconnect();
        }
    }
}

