/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.dmcdw.core;

import com.agfa.pacs.data.export.dmcdw.core.ExecutionStatus;
import com.agfa.pacs.data.export.dmcdw.core.ExecutionStatusInfo;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class DicomMediaCreationStatus {
    private Attributes dataset;

    public DicomMediaCreationStatus(Attributes attributes) {
        this.dataset = attributes;
    }

    public ExecutionStatus getExecutionStatus() {
        return ExecutionStatus.get(this.dataset.getString(0x21000020));
    }

    public ExecutionStatusInfo getExecutionStatusInfo() {
        return ExecutionStatusInfo.get(this.dataset.getString(553648176));
    }

    public int getTotalNumberOfPiecesOfMediaCreated() {
        return this.dataset.getInt(0x2200000B, -1);
    }

    public List<FailedInstance> getFailedInstances() {
        ArrayList<FailedInstance> arrayList = new ArrayList<FailedInstance>();
        Sequence sequence = this.dataset.getSequence(528792);
        int n = 0;
        while (n < sequence.size()) {
            Attributes attributes = (Attributes)sequence.get(n);
            arrayList.add(new FailedInstance(attributes));
            ++n;
        }
        return arrayList;
    }

    public List<MediaFileSet> getCreatedMediaFileSets() {
        ArrayList<MediaFileSet> arrayList = new ArrayList<MediaFileSet>();
        Sequence sequence = this.dataset.getSequence(0x2200000D);
        int n = 0;
        while (n < sequence.size()) {
            Attributes attributes = (Attributes)sequence.get(n);
            arrayList.add(new MediaFileSet(attributes));
            ++n;
        }
        return arrayList;
    }

    public class FailedInstance {
        public FailedInstance(Attributes attributes) {
            DicomMediaCreationStatus.this.dataset = attributes;
        }

        public String getReason() {
            return DicomMediaCreationStatus.this.dataset.getString(528791);
        }

        public int[] getAttributes() {
            return DicomMediaCreationStatus.this.dataset.getInts(528791);
        }

        public String getRequestedMediaApplicationProfile() {
            return DicomMediaCreationStatus.this.dataset.getString(0x2200000C);
        }

        public String getReferencedSOPInstanceUID() {
            return DicomMediaCreationStatus.this.dataset.getString(528725);
        }

        public String getReferencedSOPClassUID() {
            return DicomMediaCreationStatus.this.dataset.getString(528720);
        }
    }

    public class MediaFileSet {
        public MediaFileSet(Attributes attributes) {
            DicomMediaCreationStatus.this.dataset = attributes;
        }

        public String getStorageMediaFileSetID() {
            return DicomMediaCreationStatus.this.dataset.getString(8913200);
        }

        public String getStorageMediaFileSetUID() {
            return DicomMediaCreationStatus.this.dataset.getString(8913216);
        }
    }
}

