/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.internal;

import com.agfa.pacs.data.export.IFileIDProvider;
import com.agfa.pacs.data.export.internal.ImpaxEEProfile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.media.DicomDirWriter;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.UIDUtils;

public class DicomDirCreatorBase {
    private static final ImpaxEEProfile appProfile = new ImpaxEEProfile();
    private String fileSetID;
    private File dirFile;
    private DicomDirWriter dicomDirWriter;
    private final IFileIDProvider fileIDProvider;

    public DicomDirCreatorBase(String string, IFileIDProvider iFileIDProvider, File file) throws IOException {
        this.fileSetID = string;
        this.dirFile = file != null ? file : File.createTempFile("listtext", "dicomdir");
        this.dirFile.deleteOnExit();
        this.fileIDProvider = iFileIDProvider;
        this.init();
    }

    public String getFileSetID() {
        return this.fileSetID;
    }

    public IFileIDProvider getFileIDProvider() {
        return this.fileIDProvider;
    }

    private void init() throws IOException {
        DicomDirWriter.createEmptyDirectory((File)this.dirFile, (String)UIDUtils.createUID(), (String)this.fileSetID, null, null);
        this.dicomDirWriter = DicomDirWriter.open((File)this.dirFile);
    }

    public synchronized String[] addToDicomDir(Attributes attributes) throws IOException {
        return this.addToDicomDir(attributes, null);
    }

    public synchronized String[] addToDicomDir(Attributes attributes, Attributes attributes2) throws IOException {
        return this.addToDicomDir(attributes, attributes2, this.fileIDProvider.getFileIDs(attributes, 0));
    }

    protected final synchronized String[] addToDicomDir(Attributes attributes, Attributes attributes2, String[] stringArray) throws IOException {
        if (!attributes.contains(131074)) {
            attributes.setString(131074, VR.UI, attributes.getString(524310));
        }
        if (!attributes.contains(131075)) {
            attributes.setString(131075, VR.UI, attributes.getString(524312));
        }
        Attributes attributes3 = appProfile.makePatientDirectoryRecord(attributes);
        Attributes attributes4 = appProfile.makeStudyDirectoryRecord(attributes);
        Attributes attributes5 = appProfile.makeSeriesDirectoryRecord(attributes);
        Attributes attributes6 = appProfile.makeInstanceDirectoryRecord(attributes, stringArray);
        if (attributes2 != null) {
            attributes6.newSequence(0x880200, 1).add(attributes2);
        }
        attributes3 = this.dicomDirWriter.findOrAddPatientRecord(attributes3);
        attributes4 = this.dicomDirWriter.findOrAddStudyRecord(attributes3, attributes4);
        attributes5 = this.dicomDirWriter.findOrAddSeriesRecord(attributes4, attributes5);
        this.dicomDirWriter.addLowerDirectoryRecord(attributes5, attributes6);
        return stringArray;
    }

    public synchronized void commitDicomDir() throws IOException {
        this.dicomDirWriter.commit();
    }

    public synchronized void rollbackDicomDir() throws IOException {
        this.dicomDirWriter.rollback();
    }

    public synchronized void finishDicomDir() throws IOException {
        this.dicomDirWriter.close();
    }

    public long getSize() throws IOException {
        return this.dirFile.length();
    }

    public InputStream getAsInputStream() throws IOException {
        return Files.newInputStream(this.dirFile.toPath(), new OpenOption[0]);
    }

    public void writeToOutputStream(OutputStream outputStream) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = Files.newInputStream(this.dirFile.toPath(), new OpenOption[0]);){
            StreamUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

