/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.internal;

import com.agfa.pacs.data.export.IFileIDProvider;
import com.agfa.pacs.data.export.internal.IDSource;
import com.agfa.pacs.data.shared.util.PatientKeyUtils;
import java.util.HashMap;
import java.util.Objects;
import org.dcm4che3.data.Attributes;

public class DicomDirFileIDProvider
implements IFileIDProvider {
    private final boolean flatStructure;
    private final HashMap<ObjectKey, String> fileIDs;

    public DicomDirFileIDProvider(boolean bl) {
        this.flatStructure = bl;
        this.fileIDs = new HashMap();
    }

    public boolean isFlatStructure() {
        return this.flatStructure;
    }

    @Override
    public synchronized String[] getFileIDs(Attributes attributes, int n) {
        if (this.flatStructure) {
            String[] stringArray = new String[]{this.getFileID(ObjectKey.Level.Object, attributes.getString(524312))};
            return stringArray;
        }
        String[] stringArray = new String[]{this.getFileID(ObjectKey.Level.Patient, PatientKeyUtils.generatePatientKey(attributes)), this.getFileID(ObjectKey.Level.Study, attributes.getString(0x20000D)), this.getFileID(ObjectKey.Level.Series, attributes.getString(0x20000E)), this.getFileID(ObjectKey.Level.Object, attributes.getString(524312))};
        return stringArray;
    }

    protected String getFileID(ObjectKey.Level level, String string) {
        ObjectKey objectKey = new ObjectKey(level, string);
        if (!this.fileIDs.containsKey(objectKey)) {
            this.fileIDs.put(objectKey, IDSource.createFileID());
        }
        return this.fileIDs.get(objectKey);
    }

    protected static final class ObjectKey {
        private final Level level;
        private final String key;

        public ObjectKey(Level level, String string) {
            this.level = level;
            this.key = string;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ObjectKey)) {
                return false;
            }
            ObjectKey objectKey = (ObjectKey)object;
            return Objects.equals((Object)this.level, (Object)objectKey.level) && Objects.equals(this.key, objectKey.key);
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + Objects.hashCode((Object)this.level);
            n = 37 * n + Objects.hashCode(this.key);
            return n;
        }

        public static enum Level {
            Patient,
            Study,
            Series,
            Object;

        }
    }
}

