/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.code;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.dcm4che3.data.Attributes;

public class Code
extends AbstractDatasetSource {
    private String codingSchemeDesignator;
    private String codingSchemeVersion;
    private String codeMeaning;
    private String codeValue;
    public static final Code DocumentTitleModifier = new Code("DCM", "113011", "Document Title Modifier");
    public static final Code KeyObjectDescription = new Code("DCM", "113012", "Key Object Description");
    public static final Code ObserverType = new Code("DCM", "121005", "ObserverType");
    public static final Code ObserverTypePerson = new Code("DCM", "121006", "Person");
    public static final Code ObserverTypeDevice = new Code("DCM", "121007", "Device");
    public static final Code PersonObserverName = new Code("DCM", "121008", "Person Observer Name");
    public static final Code PersonObserverOrganizationName = new Code("DCM", "121009", "Person Observer's Organization Name");
    public static final Code PersonObserverRoleInOrganization = new Code("DCM", "121010", "Person Observer's Role in the Organization");
    public static final Code PersonObserverRoleInProcedure = new Code("DCM", "121011", "Person Observer's Role in this Procedure");
    public static final Code LanguageOfContentItemsAndDescendants = new Code("DCM", "121049", "Language of Content Item and Descendants");
    public static final Code LanguageEnglish = new Code("ISO369_2", "eng", "English");

    public Code() {
    }

    public Code(String string, String string2, String string3) {
        this.codeMeaning = string3;
        this.codeValue = string2;
        this.codingSchemeDesignator = string;
    }

    public Code(String string, String string2, String string3, String string4) {
        this.codeMeaning = string4;
        this.codeValue = string3;
        this.codingSchemeDesignator = string;
        this.codingSchemeVersion = string2;
    }

    public Code(Code code) {
        this.codeMeaning = code.getCodeMeaning();
        this.codeValue = code.getCodeValue();
        this.codingSchemeDesignator = code.getCodingSchemeDesignator();
        this.codingSchemeVersion = code.getCodingSchemeVersion();
    }

    private Code(Attributes attributes) {
        this.codingSchemeDesignator = this.getString(attributes, 524546);
        this.codingSchemeVersion = this.getString(attributes, 524547);
        this.codeMeaning = this.getString(attributes, 524548);
        this.codeValue = this.getString(attributes, 524544);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Code code = (Code)object;
        if (!Objects.equals(this.codingSchemeDesignator, code.codingSchemeDesignator)) {
            return false;
        }
        return Objects.equals(this.codeValue, code.codeValue);
    }

    public int hashCode() {
        return this.codingSchemeDesignator.hashCode() ^ this.codeValue.hashCode();
    }

    public static Code create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return new Code(attributes);
    }

    public static Code create(Attributes attributes, int n) {
        List<Code> list = Code.createList((List<Attributes>)attributes.getSequence(n));
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static List<Code> createList(Attributes attributes, int n) {
        return Code.createList((List<Attributes>)attributes.getSequence(n));
    }

    public static List<Code> createList(List<Attributes> list) {
        ArrayList<Code> arrayList = new ArrayList<Code>(2);
        if (list == null) {
            return arrayList;
        }
        int n = 0;
        while (n < list.size()) {
            Code code = Code.create(list.get(n));
            if (code != null) {
                arrayList.add(code);
            }
            ++n;
        }
        return arrayList;
    }

    public String getCodeMeaning() {
        return this.codeMeaning;
    }

    public String getCodeValue() {
        return this.codeValue;
    }

    public String getCodingSchemeDesignator() {
        return this.codingSchemeDesignator;
    }

    public String getCodingSchemeVersion() {
        return this.codingSchemeVersion;
    }

    public void setCodeMeaning(String string) {
        this.codeMeaning = string;
    }

    public void setCodeValue(String string) {
        this.codeValue = string;
    }

    public void setCodingSchemeDesignator(String string) {
        this.codingSchemeDesignator = string;
    }

    public void setCodingSchemeVersion(String string) {
        this.codingSchemeVersion = string;
    }

    public String toString() {
        return this.getCodeMeaning();
    }

    @Override
    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.codingSchemeDesignator, attributes, 524546, DatasetAccessor.Type.Mandatory);
        this.set(this.codeMeaning, attributes, 524548, DatasetAccessor.Type.Mandatory);
        this.set(this.codeValue, attributes, 524544, DatasetAccessor.Type.Mandatory);
        this.set(this.codingSchemeVersion, attributes, 524547, DatasetAccessor.Type.ConditionalMandatory);
        return attributes;
    }
}

