/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.dicom;

import com.agfa.pacs.data.shared.dicom.DicomEnum;

public enum UIDType implements DicomEnum
{
    Image("image", true),
    Video("video", true),
    KeyObject("keyobject", true),
    Composite("composite", true),
    StructuredReport("structuredreport", true),
    Presentation("presentation", true),
    Waveform("waveform", true),
    HangingProtocol("hangingprotocol", true),
    USVolume("usvolume", true),
    CC("cc", false),
    Multiframe("multiframe", false),
    SecondaryCapture("sc", false),
    ComputedReport("computedreport", false),
    ForProcessing("forprocessing", false),
    ECG("ecg", false),
    Ophthalmic("ophthalmic", false),
    Default("default", false),
    Lossless("lossless", false),
    Lossy("lossy", false),
    Encapsulated("encapsulated", false);

    private final String dicomId;
    private final boolean baseType;

    private UIDType(String string2, boolean bl) {
        this.dicomId = string2;
        this.baseType = bl;
    }

    @Override
    public String dicom() {
        return this.dicomId;
    }

    public boolean isBaseType() {
        return this.baseType;
    }

    public static UIDType get(String string) {
        UIDType[] uIDTypeArray = UIDType.values();
        int n = uIDTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIDType uIDType = uIDTypeArray[n2];
            if (uIDType.dicom().equals(string)) {
                return uIDType;
            }
            ++n2;
        }
        return null;
    }
}

