/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.util;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che3.data.Attributes;

public class PatientKeyUtils {
    private static final char LEGACY_DELIMITER = '_';
    private static final char DELIMITER = '|';
    private static final char ISSUER_DELIMITER = '\u00a7';

    public static String generatePatientKey(Attributes attributes) {
        String string = attributes.getString(0x100020, null);
        String string2 = attributes.getString(0x100021, null);
        String string3 = attributes.getString(0x100010, null);
        if (string3 != null) {
            string3 = StringUtils.stripEnd((String)string3, (String)"^");
        }
        return PatientKeyUtils.generatePatientKey(string, string3, string2);
    }

    public static String generatePatientKey(String string, String string2) {
        return PatientKeyUtils.generatePatientKey(string, string2, null);
    }

    public static String generatePatientKey(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append('|');
        if (string2 != null) {
            stringBuilder.append(string2.toUpperCase(Locale.getDefault()));
        }
        if (string3 != null) {
            stringBuilder.append('\u00a7');
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    public static boolean patientKeysEquals(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static String extractPatientId(String string) {
        int n = string.indexOf(124);
        if (n < 0) {
            n = string.indexOf(95);
        }
        if (n >= 0) {
            return string.substring(0, n);
        }
        return null;
    }

    public static String extractPatientName(String string) {
        int n = string.lastIndexOf(167);
        int n2 = string.indexOf(124);
        if (n2 < 0) {
            n2 = string.indexOf(95);
        }
        if (n2 >= 0) {
            if (n > n2) {
                return string.substring(n2 + 1, n);
            }
            return string.substring(n2 + 1);
        }
        return null;
    }

    public static String extractIssuerOfPatientId(String string) {
        int n = string.lastIndexOf(167);
        if (n >= 0) {
            return string.substring(n + 1, string.length());
        }
        return null;
    }
}

