/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.general;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.general.SOPInstanceReference;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class ReferencedSeries
extends AbstractDatasetSource {
    private String seriesInstanceUID;
    private String[] retrieveAETs;
    private String retrieveLocationUID;
    private List<ReferencedSOP> referencedSOP;
    private SOPInstanceReference studyRef;

    public ReferencedSeries(String string) {
        this.seriesInstanceUID = string;
        this.referencedSOP = new ArrayList<ReferencedSOP>();
    }

    public ReferencedSeries(String string, String string2, String string3) {
        this(string);
        this.referencedSOP.add(new ReferencedSOP(string3, string2));
    }

    private ReferencedSeries(Attributes attributes) {
        this.seriesInstanceUID = this.getString(attributes, 0x20000E);
        this.retrieveAETs = this.getStrings(attributes, 524372);
        this.referencedSOP = ReferencedSOP.createList(attributes, 528793);
    }

    public static ReferencedSeries create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(0x20000E) && attributes.contains(528793)) {
            return new ReferencedSeries(attributes);
        }
        return null;
    }

    public static List<ReferencedSeries> createList(Attributes attributes, int n) {
        ArrayList<ReferencedSeries> arrayList = new ArrayList<ReferencedSeries>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            ReferencedSeries referencedSeries = ReferencedSeries.create((Attributes)sequence.get(n2));
            if (referencedSeries != null) {
                arrayList.add(referencedSeries);
            }
            ++n2;
        }
        return arrayList;
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public String[] getRetrieveAETs() {
        return ReferencedSeries.copyArray(this.retrieveAETs);
    }

    public void setRetrieveAETs(String[] stringArray) {
        this.retrieveAETs = ReferencedSeries.copyArray(stringArray);
    }

    public String getRetrieveLocationUID() {
        return this.retrieveLocationUID;
    }

    public void setRetrieveLocationUID(String string) {
        this.retrieveLocationUID = string;
    }

    public List<ReferencedSOP> referencedSOP() {
        return this.referencedSOP;
    }

    public void addReferencedSOPs(List<ReferencedSOP> list) {
        for (ReferencedSOP referencedSOP : list) {
            referencedSOP.setSeries(this);
            this.referencedSOP.add(referencedSOP);
        }
    }

    @Override
    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.seriesInstanceUID, attributes, 0x20000E, DatasetAccessor.Type.Mandatory);
        this.set(this.retrieveAETs, attributes, 524372, DatasetAccessor.Type.Optional);
        this.set(this.referencedSOP, attributes, 528793, DatasetAccessor.Type.Mandatory);
        return attributes;
    }

    public SOPInstanceReference getStudyRef() {
        return this.studyRef;
    }

    public void setStudyRef(SOPInstanceReference sOPInstanceReference) {
        this.studyRef = sOPInstanceReference;
    }
}

