/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.general;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class ReferencedWaveform
extends AbstractDatasetSource {
    private String sopInstanceUID;
    private String sopClassUID;
    private int[] referencedWaveformChannels;

    private ReferencedWaveform(Attributes attributes) {
        this.sopClassUID = this.getString(attributes, 528720);
        this.sopInstanceUID = this.getString(attributes, 528725);
        this.referencedWaveformChannels = this.getIntegers(attributes, 4235440);
    }

    public ReferencedWaveform(String string, String string2, int[] nArray) {
        this.sopClassUID = string;
        this.sopInstanceUID = string2;
        this.referencedWaveformChannels = ReferencedWaveform.copyArray(nArray);
    }

    @Override
    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.sopClassUID, attributes, 528720, DatasetAccessor.Type.Mandatory);
        this.set(this.sopInstanceUID, attributes, 528725, DatasetAccessor.Type.Mandatory);
        this.set(this.referencedWaveformChannels, attributes, 4235440, DatasetAccessor.Type.ConditionalMandatory);
        return attributes;
    }

    public static ReferencedWaveform create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(528720) && attributes.contains(528725)) {
            return new ReferencedWaveform(attributes);
        }
        return null;
    }

    public static List<ReferencedWaveform> createList(Attributes attributes, int n) {
        ArrayList<ReferencedWaveform> arrayList = new ArrayList<ReferencedWaveform>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            ReferencedWaveform referencedWaveform = ReferencedWaveform.create((Attributes)sequence.get(n2));
            if (referencedWaveform != null) {
                arrayList.add(referencedWaveform);
            }
            ++n2;
        }
        return arrayList;
    }

    public int[] getReferencedWaveformChannels() {
        return ReferencedWaveform.copyArray(this.referencedWaveformChannels);
    }

    public String getSOPClassUID() {
        return this.sopClassUID;
    }

    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }
}

