/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee;

import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTTPHeaderUtils {
    private static final Pattern FILENAME_PATTERN = Pattern.compile("filename=\"([^\"]+)\"");
    private static final Pattern ILLEGAL_CHARACTER_PATTERN = HTTPHeaderUtils.createIllegalCharacterPattern();
    private static final String ILLEGAL_CHARACTER_REPLACEMENT = "_";

    private static Pattern createIllegalCharacterPattern() {
        char[] cArray = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray2 = cArray;
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray2[n2];
            if (stringBuilder.length() > 0) {
                stringBuilder.append('|');
            }
            stringBuilder.append(Pattern.quote(String.valueOf(c)));
            ++n2;
        }
        return Pattern.compile(stringBuilder.toString());
    }

    private HTTPHeaderUtils() {
    }

    public static String readFileName(URLConnection uRLConnection) {
        return HTTPHeaderUtils.readFileName(uRLConnection.getHeaderField("Content-Disposition"));
    }

    public static String readFileName(String string) {
        Matcher matcher;
        if (string != null && (matcher = FILENAME_PATTERN.matcher(string)).find()) {
            return HTTPHeaderUtils.cleanFilename(matcher.group(1));
        }
        return null;
    }

    public static String cleanFilename(String string) {
        return ILLEGAL_CHARACTER_PATTERN.matcher(string).replaceAll(ILLEGAL_CHARACTER_REPLACEMENT);
    }
}

