/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.PersonName;

public class MediumLabelUtil {
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd");
        }
    };
    private static final List<PatternPair> REPLACEMENT_PATTERNS = new ArrayList<PatternPair>();

    static {
        REPLACEMENT_PATTERNS.add(new PatternPair(Pattern.compile(" "), "_"));
        REPLACEMENT_PATTERNS.add(new PatternPair(Pattern.compile("\u00c4"), "AE"));
        REPLACEMENT_PATTERNS.add(new PatternPair(Pattern.compile("\u00d6"), "OE"));
        REPLACEMENT_PATTERNS.add(new PatternPair(Pattern.compile("\u00dc"), "UE"));
        REPLACEMENT_PATTERNS.add(new PatternPair(Pattern.compile("[^A-Z\\_0-9]"), ""));
    }

    private MediumLabelUtil() {
    }

    public static String makeFileSetID(String string) {
        if (string == null) {
            return "";
        }
        string = string.toUpperCase(Locale.ENGLISH);
        for (PatternPair patternPair : REPLACEMENT_PATTERNS) {
            string = patternPair.pattern.matcher(string).replaceAll(patternPair.replacement);
        }
        return StringUtils.abbreviate((String)string, (int)16);
    }

    public static String generateMediumLabel(Collection<Attributes> collection) {
        if (collection != null && collection.size() == 1) {
            return MediumLabelUtil.generateSinglePatientMediumLabel(collection.iterator().next());
        }
        return MediumLabelUtil.generateMultiPatientMediumLabel();
    }

    public static String generateSinglePatientMediumLabel(Attributes attributes) {
        PersonName personName = new PersonName(attributes.getString(0x100010), true);
        return MediumLabelUtil.makeFileSetID(personName.get(PersonName.Component.FamilyName));
    }

    public static String generateMultiPatientMediumLabel() {
        return MediumLabelUtil.makeFileSetID("MuPat" + DATE_FORMAT.get().format(new Date()));
    }

    private static class PatternPair {
        public final String replacement;
        public final Pattern pattern;

        public PatternPair(Pattern pattern, String string) {
            this.replacement = string;
            this.pattern = pattern;
        }
    }
}

