/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.awt;

import com.agfa.hap.pacs.impaxee.awt.IImageHolder;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;

public abstract class AbstractBufferedImageHolder
implements IImageHolder {
    public final BufferedImage image;
    public final Graphics2D graphics;
    public final int width;
    private final int scanlineStride;
    private final int pixelStride;
    public final int height;
    public final int numPixels;
    public boolean imgInvalid = true;
    public boolean locked = false;
    public final int iofs;
    public final int iline;

    protected AbstractBufferedImageHolder(BufferedImage bufferedImage) {
        this(bufferedImage, null);
    }

    protected AbstractBufferedImageHolder(BufferedImage bufferedImage, int n, int n2, int n3) {
        this(bufferedImage, new SubImageData(n, n2, n3));
    }

    private AbstractBufferedImageHolder(BufferedImage bufferedImage, SubImageData subImageData) {
        int n;
        int n2;
        this.image = bufferedImage;
        this.graphics = bufferedImage.createGraphics();
        this.graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        this.graphics.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        this.graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        this.graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.numPixels = this.width * this.height;
        SampleModel sampleModel = bufferedImage.getRaster().getSampleModel();
        int n3 = 0;
        if (subImageData != null) {
            n3 = subImageData.iofs;
            n2 = subImageData.scanlineStride;
            n = subImageData.pixelStride;
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            n2 = singlePixelPackedSampleModel.getScanlineStride();
            n = 1;
        } else if (sampleModel instanceof PixelInterleavedSampleModel) {
            PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
            n2 = pixelInterleavedSampleModel.getScanlineStride();
            n = pixelInterleavedSampleModel.getPixelStride();
        } else {
            n2 = -1;
            n = -1;
        }
        this.scanlineStride = n2;
        this.pixelStride = n;
        this.iofs = n3;
        this.iline = this.scanlineStride / this.pixelStride;
    }

    public void clear() {
        this.graphics.clearRect(0, 0, this.width, this.height);
    }

    public void release() {
        this.graphics.dispose();
        this.image.flush();
    }

    @Override
    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getOffset() {
        return this.iofs;
    }

    @Override
    public int getScanlineStride() {
        return this.scanlineStride;
    }

    @Override
    public int getPixelStride() {
        return this.pixelStride;
    }

    private static class SubImageData {
        final int iofs;
        final int scanlineStride;
        final int pixelStride;

        SubImageData(int n, int n2, int n3) {
            this.iofs = n;
            this.scanlineStride = n2;
            this.pixelStride = n3;
        }
    }
}

