/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.awt;

import com.agfa.hap.pacs.impaxee.awt.AbstractBufferedImageHolder;
import com.agfa.hap.pacs.impaxee.awt.IImageHolder;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.ByteComponentRaster;

class ByteInterleavedRGBBufferedImageHolder
extends AbstractBufferedImageHolder {
    private final byte[] data;

    ByteInterleavedRGBBufferedImageHolder(BufferedImage bufferedImage) {
        super(bufferedImage);
        this.data = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
    }

    static boolean isCompatible(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = writableRaster.getNumBands();
        if (n == 3 && ByteInterleavedRGBBufferedImageHolder.isCompatibleColorModel(bufferedImage.getColorModel(), n) && writableRaster instanceof ByteComponentRaster && ((ByteComponentRaster)writableRaster).getPixelStride() == n && writableRaster.getSampleModel() instanceof PixelInterleavedSampleModel) {
            int[] nArray = ((PixelInterleavedSampleModel)writableRaster.getSampleModel()).getBandOffsets();
            return nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2;
        }
        return false;
    }

    private static boolean isCompatibleColorModel(ColorModel colorModel, int n) {
        return colorModel.getNumComponents() == n && colorModel instanceof ComponentColorModel && !colorModel.hasAlpha() && ByteInterleavedRGBBufferedImageHolder.is8Bit(colorModel, n);
    }

    private static boolean is8Bit(ColorModel colorModel, int n) {
        int[] nArray = colorModel.getComponentSize();
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] != 8) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public byte[] getImageArray() {
        return this.data;
    }

    @Override
    public boolean isGrayscale() {
        return false;
    }

    @Override
    public IImageHolder.BufferedImageType getType() {
        return IImageHolder.BufferedImageType.BYTE_INTERLEAVED_RGB;
    }
}

