/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.awt;

import com.agfa.hap.pacs.impaxee.awt.AbstractBufferedImageHolder;
import com.agfa.hap.pacs.impaxee.awt.ByteInterleavedRGBBufferedImageHolder;
import com.agfa.hap.pacs.impaxee.awt.GrayscaleBufferedImageHolder;
import com.agfa.hap.pacs.impaxee.awt.IImageHolder;
import com.agfa.hap.pacs.impaxee.awt.IntColorBufferedImageHolder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageHolderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageHolderFactory.class);

    private ImageHolderFactory() {
    }

    public static IImageHolder createImageHolder(BufferedImage bufferedImage) {
        AbstractBufferedImageHolder abstractBufferedImageHolder;
        switch (bufferedImage.getType()) {
            case 10: {
                abstractBufferedImageHolder = new GrayscaleBufferedImageHolder(bufferedImage);
                break;
            }
            case 1: 
            case 2: {
                abstractBufferedImageHolder = new IntColorBufferedImageHolder(bufferedImage);
                break;
            }
            case 0: {
                if (ByteInterleavedRGBBufferedImageHolder.isCompatible(bufferedImage)) {
                    abstractBufferedImageHolder = new ByteInterleavedRGBBufferedImageHolder(bufferedImage);
                    break;
                }
            }
            default: {
                LOGGER.debug("Converting image from type {} to RGB", (Object)bufferedImage.getType());
                IntColorBufferedImageHolder intColorBufferedImageHolder = new IntColorBufferedImageHolder(bufferedImage.getWidth(), bufferedImage.getHeight());
                intColorBufferedImageHolder.getGraphics().drawImage((Image)bufferedImage, 0, 0, null);
                abstractBufferedImageHolder = intColorBufferedImageHolder;
            }
        }
        return abstractBufferedImageHolder;
    }
}

