/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.awt;

import com.agfa.hap.pacs.impaxee.awt.IImageHolder;
import com.agfa.hap.pacs.impaxee.awt.IIntColorImageHolder;
import com.agfa.hap.pacs.impaxee.awt.IntColorBufferedImageHolder;
import com.agfa.hap.pacs.impaxee.awt.OutlineFontLarge;
import com.agfa.hap.pacs.impaxee.awt.OutlineFontSmall;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;

public abstract class OutlineFont {
    protected static final int bdc = -16777216;
    private static final int BRIGHT_BORDER_COLOR = -5658199;
    private static final int helperColor = -1;
    protected int height;
    protected static final int fillc = -8388608;
    protected final int fgc;
    protected FontMetrics myFM;
    protected FontMap fontMap;

    protected OutlineFont(Font font, FontMetrics fontMetrics, int n) {
        this.fgc = n;
        this.myFM = fontMetrics;
        this.height = fontMetrics.getHeight();
        this.fontMap = new FontMap(font);
    }

    static OutlineFont getInstance(Font font, FontMetrics fontMetrics, int n) {
        OutlineFont outlineFont = fontMetrics.getHeight() < 20 ? new OutlineFontSmall(font, fontMetrics, n) : new OutlineFontLarge(font, fontMetrics, n);
        return outlineFont;
    }

    public FontMetrics getFontMetrics() {
        return this.myFM;
    }

    protected int getBaseline() {
        return this.height - this.myFM.getMaxDescent() + 2;
    }

    protected int getOffset() {
        return (int)Math.ceil(0.6111111111111112 + (double)this.myFM.getFont().getSize() / 23.0);
    }

    protected abstract FontMapEntry createFontMapEntry(int var1, IIntColorImageHolder var2, int var3);

    public int stringWidth(String string) {
        return this.bytesWidth(string.toCharArray(), 0, string.length());
    }

    public int bytesWidth(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2) {
            n3 += this.fontMap.getFontMapEntry((char)cArray[n4]).width[cArray[n4] & 0xFF];
            ++n4;
        }
        return n3;
    }

    public void drawBytes(char[] cArray, IImageHolder iImageHolder, int n, int n2) {
        this.drawBytes(cArray, 0, cArray.length, iImageHolder, n, n2, this.fgc, -16777216);
    }

    public void drawBytes(char[] cArray, Color color, int n, int n2, IImageHolder iImageHolder, int n3, int n4) {
        int n5 = color != null ? color.getRGB() : this.fgc;
        this.drawBytes(cArray, n, n2, iImageHolder, n3, n4, n5, this.getBorderColor(color));
    }

    private int getBorderColor(Color color) {
        if (color != null && color.getRed() == 0 && color.getGreen() == 0 && color.getBlue() == 0) {
            return -5658199;
        }
        return -16777216;
    }

    protected abstract void drawBytes(char[] var1, int var2, int var3, IImageHolder var4, int var5, int var6, int var7, int var8);

    public void drawBytes(char[] cArray, Color color, IImageHolder iImageHolder, int n, int n2) {
        int n3 = color != null ? color.getRGB() : this.fgc;
        this.drawBytes(cArray, 0, cArray.length, iImageHolder, n, n2, n3, this.getBorderColor(color));
    }

    protected class FontMap {
        private FontMapEntry[] entries = new FontMapEntry[256];
        private Font font;

        public FontMap() {
            int n = 0;
            while (n < 256) {
                this.entries[n] = null;
                ++n;
            }
        }

        public FontMap(Font font) {
            this();
            this.font = font;
        }

        public FontMapEntry getFontMapEntry(char c) {
            int n = c >> 8 & 0xFF;
            if (this.entries[n] == null) {
                IntColorBufferedImageHolder intColorBufferedImageHolder = new IntColorBufferedImageHolder(OutlineFont.this.height * 3, OutlineFont.this.height + 8);
                intColorBufferedImageHolder.graphics.setFont(this.font);
                intColorBufferedImageHolder.graphics.setColor(new Color(-1));
                this.entries[n] = OutlineFont.this.createFontMapEntry(n, intColorBufferedImageHolder, -1);
                intColorBufferedImageHolder.release();
            }
            return this.entries[n];
        }
    }

    protected static class FontMapEntry {
        public int[] width = new int[256];
    }
}

