/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.awt;

import com.agfa.hap.pacs.impaxee.awt.OutlineFont;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Arrays;
import java.util.Optional;

public class OutlineFontCache {
    private final OutlineFont[] fontCache;
    private int fcIndex;
    private final int defaultColor;

    public OutlineFontCache(int n, Color color) {
        this.fontCache = new OutlineFont[n];
        this.defaultColor = color.getRGB();
    }

    public OutlineFont getOutlineFont(Font font, FontMetrics fontMetrics) {
        OutlineFont outlineFont2;
        Optional<OutlineFont> optional = Arrays.stream(this.fontCache).filter(outlineFont -> outlineFont != null).filter(outlineFont -> outlineFont.getFontMetrics().getFont().equals(font)).findAny();
        if (optional.isPresent()) {
            return optional.get();
        }
        this.fontCache[this.fcIndex] = outlineFont2 = OutlineFont.getInstance(font, fontMetrics, this.defaultColor);
        this.fcIndex = (this.fcIndex + 1) % this.fontCache.length;
        return outlineFont2;
    }
}

