/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.enhanced;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;

public class EnhancedMapping {
    private static final Set<String> MULTIFRAME_SOP_CLASSES = new HashSet<String>();
    private static final int UNKNOWN_SEQUENCE_TAG = -1;
    private static Map<Integer, Integer> tagMapping = new HashMap<Integer, Integer>();
    private static Map<Integer, Integer> sameTagMapping = new HashMap<Integer, Integer>();

    static {
        MULTIFRAME_SOP_CLASSES.add("1.2.840.10008.5.1.4.1.1.2.1");
        MULTIFRAME_SOP_CLASSES.add("1.2.840.10008.5.1.4.1.1.4.1");
        MULTIFRAME_SOP_CLASSES.add("1.2.840.10008.5.1.4.1.1.13.1.3");
        MULTIFRAME_SOP_CLASSES.add("1.2.840.10008.5.1.4.1.1.77.1.5.4");
        MULTIFRAME_SOP_CLASSES.add("1.2.840.10008.5.1.4.1.1.13.1.1");
        MULTIFRAME_SOP_CLASSES.add("1.2.840.10008.5.1.4.1.1.13.1.2");
        EnhancedMapping.addToMacro(2621488, 2658576);
        EnhancedMapping.addToMacro(1572944, 2658576);
        EnhancedMapping.addToMacro(2134358, 2134289);
        EnhancedMapping.addToMacro(1610065, 2134289);
        EnhancedMapping.addToMacro(1609844, 2134289);
        EnhancedMapping.addToMacro(1610272, 2134289);
        EnhancedMapping.addToMacro(1610294, 2134289);
        EnhancedMapping.addToMacro(1610260, 2134289);
        EnhancedMapping.addToMacro(2134359, 2134289);
        EnhancedMapping.addToMacro(2134312, 2134289);
        EnhancedMapping.addToMacro(2134102, 2134289);
        EnhancedMapping.addToMacro(2134103, 2134289);
        EnhancedMapping.addToMacro(2134360, 2134289);
        EnhancedMapping.addToMacro(2135123, 2134289);
        EnhancedMapping.addToMacro(0x200032, 2134291);
        EnhancedMapping.addToMacro(2097207, 2134294);
        EnhancedMapping.addToMacro(2134130, 2134129);
        EnhancedMapping.addToMacro(2625618, 2658629);
        EnhancedMapping.addToMacro(2625619, 2658629);
        EnhancedMapping.addToMacro(2625620, 2658629);
        EnhancedMapping.addToMacro(2625616, 2658610);
        EnhancedMapping.addToMacro(2625617, 2658610);
        EnhancedMapping.addToMacro(2625621, 2658610);
        EnhancedMapping.addToMacro(2625622, 2658610);
        EnhancedMapping.addToMacro(1610551, 1572882);
        EnhancedMapping.addToMacro(1610562, 1572882);
        EnhancedMapping.addToMacro(1610563, 1572882);
        EnhancedMapping.addToMacro(1610564, 1572882);
        EnhancedMapping.addToMacro(2633730, 2659362);
        EnhancedMapping.addToMacro(2633734, 2659362);
        EnhancedMapping.addToMacro(2659444, 2659362);
        EnhancedMapping.addToMacro(0x200020, 2135120);
        EnhancedMapping.addToMacro(2134373, 0x209222);
        EnhancedMapping.addToMacro(2134373, 0x209222);
        EnhancedMapping.addToMacro(2134547, 0x209222);
        EnhancedMapping.addToMacro(2134375, 0x209222);
        EnhancedMapping.addToMacro(2134584, 0x209222);
        EnhancedMapping.addToMacro(2135073, 0x209222);
        EnhancedMapping.addToMacro(561159, 1610537);
        EnhancedMapping.addToMacro(1610498, 1610497);
        EnhancedMapping.addToMacro(1610499, 1610497);
        EnhancedMapping.addToMacro(1610547, 1610497);
        EnhancedMapping.addToMacro(1610548, 1610497);
        EnhancedMapping.addToMacro(1577280, 1610500);
        EnhancedMapping.addToMacro(1610501, 1610500);
        EnhancedMapping.addToMacro(1610502, 1610500);
        EnhancedMapping.addToMacro(1610503, 1610500);
        EnhancedMapping.addToMacro(1577264, 1610500);
        EnhancedMapping.addToMacro(1577248, 1610500);
        EnhancedMapping.addToMacro(1573008, 1610500);
        EnhancedMapping.addToMacro(1610505, 1610504);
        EnhancedMapping.addToMacro(1610512, 1610504);
        EnhancedMapping.addToMacro(1610513, 1610504);
        EnhancedMapping.addToMacro(1610535, 1610534);
        EnhancedMapping.addToMacro(1610515, 1610534);
        EnhancedMapping.addToMacro(1610520, 1610534);
        EnhancedMapping.addToMacro(0x181110, 1610514);
        EnhancedMapping.addToMacro(1610549, 1610514);
        EnhancedMapping.addToMacro(1610517, 1610516);
        EnhancedMapping.addToMacro(1577488, 1610516);
        EnhancedMapping.addToMacro(1610518, 1610516);
        EnhancedMapping.addToMacro(0x181100, 1610516);
        EnhancedMapping.addToMacro(1610519, 1610516);
        EnhancedMapping.addToMacro(1610530, 1610516);
        EnhancedMapping.addToMacro(1610521, 1610516);
        EnhancedMapping.addToMacro(1610528, 1610516);
        EnhancedMapping.addToMacro(1610536, 1610529);
        EnhancedMapping.addToMacro(1610544, 1610529);
        EnhancedMapping.addToMacro(1610546, 1610529);
        EnhancedMapping.addToMacro(1610531, 1610529);
        EnhancedMapping.addToMacro(1610532, 1610529);
        EnhancedMapping.addToMacro(1610565, 1610529);
        EnhancedMapping.addToMacro(1610566, 1610529);
        EnhancedMapping.addToMacro(1572960, 1610533);
        EnhancedMapping.addToMacro(1577360, 1610533);
        EnhancedMapping.addToMacro(1577312, 1610533);
        EnhancedMapping.addToMacro(1601616, 1610533);
        EnhancedMapping.addToMacro(1610577, 1610533);
        EnhancedMapping.addToMacro(1610578, 1610533);
        EnhancedMapping.addToMacro(0x180080, 1610002);
        EnhancedMapping.addToMacro(1577748, 1610002);
        sameTagMapping.put(0x180081, 1609858);
        sameTagMapping.put(1572994, 1609849);
        EnhancedMapping.addToMacro(1609858, 1610004);
        EnhancedMapping.addToMacro(1609849, 1610005);
        EnhancedMapping.addToMacro(1573012, 1610021);
        EnhancedMapping.addToMacro(1577552, 1609794);
        EnhancedMapping.addToMacro(1609863, 1610007);
        EnhancedMapping.addToMacro(1609845, 1610007);
        EnhancedMapping.addToMacro(1609846, 1610007);
        EnhancedMapping.addToMacro(1611265, 1610007);
        EnhancedMapping.addToMacro(1610055, 1610007);
        sameTagMapping.put(2101313, 1610535);
    }

    private static void addToMacro(int n, int n2) {
        tagMapping.put(n, n2);
    }

    public static boolean isMultiframeSOPClass(String string) {
        return MULTIFRAME_SOP_CLASSES.contains(string);
    }

    private static int mapDicomTagToEquals(int n) {
        return EnhancedMapping.getOrDefault(sameTagMapping, n, n);
    }

    private static int getSequenceForTag(int n) {
        return EnhancedMapping.getOrDefault(tagMapping, n, -1);
    }

    private static int getOrDefault(Map<Integer, Integer> map, Integer n, int n2) {
        Integer n3 = map.get(n);
        if (n3 == null) {
            return n2;
        }
        return n3;
    }

    private static Attributes remapTags(Attributes attributes, int n, int n2) {
        if (n == n2) {
            return attributes;
        }
        Attributes attributes2 = new Attributes(2);
        VR vR = ElementDictionary.vrOf((int)n, null);
        if (vR == VR.DS) {
            attributes2.setDouble(n, vR, attributes.getDoubles(n2));
        } else {
            attributes2.setString(n, vR, attributes.getString(n2));
        }
        return attributes2;
    }

    public static Attributes getDicomElement(Attributes attributes, Attributes attributes2, int n2) {
        return EnhancedMapping.getDicomElement(attributes, n2, n -> EnhancedMapping.findSequence(n, attributes, attributes2));
    }

    public static Attributes getDicomElement(Attributes attributes, int n, IntFunction<Attributes> intFunction) {
        int n2 = EnhancedMapping.mapDicomTagToEquals(n);
        int n3 = EnhancedMapping.getSequenceForTag(n2);
        if (n3 == -1) {
            return EnhancedMapping.remapTags(attributes, n, n2);
        }
        Attributes attributes2 = intFunction.apply(n3);
        if (attributes2 == null) {
            return null;
        }
        return EnhancedMapping.remapTags(attributes2, n, n2);
    }

    public static Attributes findSequence(int n, Attributes attributes, Attributes attributes2) {
        Attributes attributes3 = null;
        if (attributes2 != null) {
            attributes3 = attributes2.getNestedDataset(n);
        }
        if (attributes3 == null && attributes.containsValue(1375769129)) {
            attributes3 = attributes.getNestedDataset(1375769129).getNestedDataset(n);
        }
        return attributes3;
    }

    public static boolean hasMappingFor(int n) {
        return tagMapping.containsKey(n) || sameTagMapping.containsKey(n);
    }
}

