/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.export;

import com.agfa.hap.pacs.data.collection.IAttributesCollection;
import com.agfa.hap.pacs.impaxee.export.StructuredReportFilter;
import com.agfa.hap.pacs.impaxee.reports.IReportMetaData;
import com.agfa.hap.pacs.impaxee.reports.ReportMetaDataComparatorFactory;
import com.agfa.hap.pacs.impaxee.reports.ReportMetaDataFactory;
import com.agfa.hap.pacs.impaxee.reports.ReportType;
import com.agfa.pacs.data.shared.dicom.IUIDConfiguration;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.listtext.dicomobject.type.VerificationFlag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che3.data.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportObjectFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ExportObjectFilter.class);
    private final Set<String> filteredSOPInstanceUIDs;
    private final boolean isAllFilteredOut;

    public ExportObjectFilter(IAttributesCollection iAttributesCollection, StructuredReportFilter structuredReportFilter, boolean bl, boolean bl2, boolean bl3, IUIDConfiguration iUIDConfiguration) {
        this.filteredSOPInstanceUIDs = ExportObjectFilter.init(iAttributesCollection, structuredReportFilter, bl, bl2, bl3, iUIDConfiguration);
        this.isAllFilteredOut = iAttributesCollection.getAttributesCount() <= this.filteredSOPInstanceUIDs.size();
    }

    public boolean isFilteredOut(Attributes attributes) {
        return this.filteredSOPInstanceUIDs.contains(ExportObjectFilter.getSOPInstanceUID(attributes));
    }

    public boolean isAllFilteredOut() {
        return this.isAllFilteredOut;
    }

    private static Collection<String> getMostRecentReports(Collection<Attributes> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        HashMap<String, ArrayList<IReportMetaData>> hashMap = new HashMap<String, ArrayList<IReportMetaData>>();
        for (Attributes object : collection) {
            IReportMetaData iReportMetaData;
            try {
                iReportMetaData = ReportMetaDataFactory.createReportMetaData(object, true);
            }
            catch (Exception exception) {
                LOG.warn("Evaluating structured report failed: " + object, (Throwable)exception);
                continue;
            }
            Date date = null;
            try {
                date = iReportMetaData.getCreationDateTime();
            }
            catch (Exception exception) {
                LOG.warn("Reading report date failed for " + iReportMetaData, (Throwable)exception);
            }
            if (date == null) {
                arrayList.add(ExportObjectFilter.getSOPInstanceUID(object));
                LOG.info("No report date set for {}", (Object)iReportMetaData);
                continue;
            }
            String string = object.getString(0x20000D);
            ArrayList<IReportMetaData> arrayList2 = (ArrayList<IReportMetaData>)hashMap.get(string);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<IReportMetaData>();
                hashMap.put(string, arrayList2);
            }
            arrayList2.add(iReportMetaData);
        }
        for (List list : hashMap.values()) {
            if (list.size() > 1) {
                Collections.sort(list, ReportMetaDataComparatorFactory.getInstance().createReportComparator());
            }
            arrayList.add(ExportObjectFilter.getSOPInstanceUID(((IReportMetaData)list.get(0)).getReportAttributes()));
        }
        return arrayList;
    }

    private static String readSCManufacturer(Attributes attributes) {
        return attributes.getString(0x181018, null);
    }

    private static Set<String> init(IAttributesCollection iAttributesCollection, StructuredReportFilter structuredReportFilter, boolean bl, boolean bl2, boolean bl3, IUIDConfiguration iUIDConfiguration) {
        String string;
        int n = iAttributesCollection.getAttributesCount();
        HashSet<String> hashSet = new HashSet<String>();
        if (structuredReportFilter != StructuredReportFilter.ALL) {
            ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
            int n2 = 0;
            while (n2 < n) {
                Attributes attributes;
                string = iAttributesCollection.getSOPClassUID(n2);
                if (!(iUIDConfiguration.getBaseType(string) != UIDType.StructuredReport || iUIDConfiguration.isType(string, UIDType.ComputedReport) || "1.2.840.10008.5.1.4.1.1.88.50".equals(string) || ExportObjectFilter.isClinAppsReport(attributes = iAttributesCollection.getDicomObjectMerged(n2)) || ExportObjectFilter.isMammoPreprocessingReport(attributes))) {
                    arrayList.add(attributes);
                    hashSet.add(ExportObjectFilter.getSOPInstanceUID(attributes));
                }
                ++n2;
            }
            if (structuredReportFilter == StructuredReportFilter.MOST_RECENT) {
                hashSet.removeAll(ExportObjectFilter.getMostRecentReports(arrayList));
            } else if (structuredReportFilter == StructuredReportFilter.VALIDATED) {
                hashSet.removeAll(ExportObjectFilter.getVerifiedReports(arrayList));
            }
        }
        if (bl) {
            int n3 = 0;
            while (n3 < n) {
                Attributes attributes = iAttributesCollection.getAttributes(n3);
                if (attributes.containsValue(1179762) && (string = attributes.getString(1179762, null)) != null && string.equals("IMPAX_ForResearch")) {
                    hashSet.add(ExportObjectFilter.getSOPInstanceUID(attributes));
                }
                ++n3;
            }
        }
        int n4 = 0;
        while (n4 < n) {
            if (ExportObjectFilter.isFiltered(iAttributesCollection, n4, bl2, bl3, iUIDConfiguration)) {
                hashSet.add(iAttributesCollection.getSOPInstanceUID(n4));
            }
            ++n4;
        }
        return hashSet;
    }

    private static boolean isFiltered(IAttributesCollection iAttributesCollection, int n, boolean bl, boolean bl2, IUIDConfiguration iUIDConfiguration) {
        String string;
        String string2 = iAttributesCollection.getSOPClassUID(n);
        if (iUIDConfiguration.isType(string2, UIDType.CC) || bl2 && "1.2.840.10008.5.1.4.1.1.104.1".equals(string2)) {
            return true;
        }
        return bl && iUIDConfiguration.isType(string2, UIDType.SecondaryCapture) && StringUtils.contains((CharSequence)(string = ExportObjectFilter.readSCManufacturer(iAttributesCollection.getDicomObjectMerged(n))), (CharSequence)"IMPAX");
    }

    private static boolean isClinAppsReport(Attributes attributes) {
        return StringUtils.containsIgnoreCase((CharSequence)attributes.getString(524400), (CharSequence)"AGFA") && ArrayUtils.contains((Object[])attributes.getStrings(524296), (Object)"CLINAPPS");
    }

    private static boolean isMammoPreprocessingReport(Attributes attributes) {
        return ReportType.getReportType(attributes, false) == ReportType.MammoPreprocessingReport;
    }

    private static Collection<String> getVerifiedReports(Collection<Attributes> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (Attributes attributes : collection) {
            try {
                IReportMetaData iReportMetaData = ReportMetaDataFactory.createReportMetaData(attributes, true);
                if (VerificationFlag.Verified != iReportMetaData.getVerificationFlag()) continue;
                arrayList.add(ExportObjectFilter.getSOPInstanceUID(attributes));
            }
            catch (Exception exception) {
                LOG.warn("Evaluating structured report failed: " + attributes, (Throwable)exception);
            }
        }
        return arrayList;
    }

    private static String getSOPInstanceUID(Attributes attributes) {
        return attributes.getString(524312);
    }
}

