/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.import_.coercion;

import com.agfa.hap.pacs.impaxee.import_.coercion.ISearchColumns;
import com.agfa.pacs.listtext.lta.worklist.data.attribute.code.BasicAttributeCodeFinder;
import com.agfa.pacs.listtext.lta.worklist.data.attribute.code.DicomAttributeCode;
import com.agfa.pacs.listtext.lta.worklist.data.attribute.code.IAttributeCode;
import com.agfa.pacs.listtext.lta.worklist.data.attribute.code.MutableAttributeCode;
import com.agfa.pacs.listtext.lta.worklist.data.attribute.code.OtherAttributeCode;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;

public class DicomSearchColumns
implements ISearchColumns {
    private static final DicomSearchColumns INSTANCE = new DicomSearchColumns();
    private final Set<IAttributeCode> standardCodes = new HashSet<IAttributeCode>();
    private final Set<IAttributeCode> requiredCodes = new LinkedHashSet<IAttributeCode>();

    private DicomSearchColumns() {
        this.addRequiredCode(OtherAttributeCode.LOAD_DATA);
        this.addRequiredCode(OtherAttributeCode.DATA_TREE);
        this.addRequiredCode(DicomAttributeCode.PATIENT_BIRTHDATE);
        this.standardCodes.add(DicomAttributeCode.PATIENT_ID);
        this.standardCodes.add(DicomAttributeCode.ISSUER_OF_PATIENT_ID);
        this.standardCodes.add(DicomAttributeCode.PATIENT_SEX);
        this.standardCodes.add(DicomAttributeCode.REF_PHYSICIAN_NAME);
        this.standardCodes.add(DicomAttributeCode.REQUESTING_SERVICE);
        this.standardCodes.add(DicomAttributeCode.BODYPART_EXAMINED);
        this.standardCodes.add(DicomAttributeCode.CLINICAL_TRIAL_SERIES_DESCRIPTION);
        this.standardCodes.add(DicomAttributeCode.ACCESSION_NR);
        this.standardCodes.add(DicomAttributeCode.STATION_NAME);
        this.standardCodes.add(MutableAttributeCode.MUTABLE_DESCRIPTION);
        this.standardCodes.add(MutableAttributeCode.MUTABLE_DATE);
        this.standardCodes.add(MutableAttributeCode.MUTABLE_TIME);
        this.standardCodes.add(MutableAttributeCode.MUTABLE_MODALITIES);
        this.standardCodes.add(OtherAttributeCode.OBJECT_COUNT);
    }

    public static DicomSearchColumns getInstance() {
        return INSTANCE;
    }

    private void addRequiredCode(IAttributeCode iAttributeCode) {
        this.requiredCodes.add(iAttributeCode);
        this.standardCodes.add(iAttributeCode);
    }

    @Override
    public IAttributeCode createCode(String string) {
        return BasicAttributeCodeFinder.find(string);
    }

    public Set<IAttributeCode> getAllColumns() {
        return Collections.unmodifiableSet(this.standardCodes);
    }

    public Iterable<IAttributeCode> getRequiredColumns() {
        return this.requiredCodes;
    }

    @Override
    public boolean isRequired(IAttributeCode iAttributeCode) {
        return this.requiredCodes.contains(iAttributeCode);
    }

    @Override
    public boolean isSearchable(int n) {
        if (ElementDictionary.getStandardElementDictionary().vrOf(n) == VR.TM) {
            return false;
        }
        switch (n) {
            case 0x201200: 
            case 0x201202: 
            case 2101764: 
            case 2101766: 
            case 2101768: 
            case 2101769: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int[] getPath(int n) {
        return new int[]{n};
    }
}

