/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.import_.coercion;

import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;
import sun.misc.CRC16;

public class IMPAX6Tagger {
    public static final String OVERRIDE_STATION_AET = "overrideStationAet";
    public static final String STATION_AET_TAG = "StationAetTag";
    public static final String STATION_AET_VALUE = "StationAetValue";
    public static final String GENERATE_NEW_ACCESSION_NR = "generateNewAccessioNR";
    public static final String ACCESSION_NR_GENERATION_SCHEME = "AccessioNRGenerationScheme";
    public static final String NEW_ACCESSION_NR = "targetAccessionNumber";
    private static final String STUDY_TO_ACCESSION_NUMBER = "studyToAccessionNumber";
    private static final long SHORT_ACCNR_BASE = 1420066800000L;
    private static final String WILDCARD = "*";
    private final boolean overrideStationAET;
    private int stationAETTag;
    private String stationAETValue;
    private final boolean generateNewAccessionNR;
    private AccessioNRGeneration accessionNRGenerationSchema;
    private Map<String, String> study2accNRMap;
    private String newAccessionNR;
    private int accessionNumberSequenceNr = 0;

    public IMPAX6Tagger(Properties properties) {
        this.overrideStationAET = IMPAX6Tagger.isStationAETOverrideActive(properties);
        if (this.overrideStationAET) {
            this.stationAETTag = (Integer)properties.get(STATION_AET_TAG);
            this.stationAETValue = properties.getProperty(STATION_AET_VALUE);
        }
        this.generateNewAccessionNR = IMPAX6Tagger.isActive(properties, GENERATE_NEW_ACCESSION_NR);
        if (this.generateNewAccessionNR) {
            this.accessionNRGenerationSchema = AccessioNRGeneration.valueOf(properties.getProperty(ACCESSION_NR_GENERATION_SCHEME));
            this.study2accNRMap = new Hashtable<String, String>();
        } else {
            this.newAccessionNR = IMPAX6Tagger.readNewAccessionNumber(properties);
        }
    }

    public static boolean isStationAETOverrideActive(Properties properties) {
        return IMPAX6Tagger.isActive(properties, OVERRIDE_STATION_AET);
    }

    private static boolean isActive(Properties properties, String string) {
        return Boolean.parseBoolean(Objects.toString(properties.get(string)));
    }

    private static String readNewAccessionNumber(Properties properties) {
        String string = properties.getProperty(NEW_ACCESSION_NR);
        if (WILDCARD.equals(StringUtils.trim((String)string))) {
            string = null;
        }
        return string;
    }

    public void prepareProcessing(Properties properties, Collection<String> collection) {
        if (this.generateNewAccessionNR) {
            if (!collection.isEmpty()) {
                for (String string : collection) {
                    this.study2accNRMap.put(string, this.accessionNRGenerationSchema.generateAccessionNR(this.accessionNumberSequenceNr));
                    ++this.accessionNumberSequenceNr;
                }
            } else {
                this.study2accNRMap.put("", this.accessionNRGenerationSchema.generateAccessionNR(this.accessionNumberSequenceNr));
                ++this.accessionNumberSequenceNr;
            }
            properties.put(STUDY_TO_ACCESSION_NUMBER, this.study2accNRMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Attributes attributes) {
        if (this.overrideStationAET) {
            attributes.setString(this.stationAETTag, ElementDictionary.vrOf((int)this.stationAETTag, null), this.stationAETValue);
        }
        if (this.generateNewAccessionNR) {
            String string = attributes.getString(0x20000D);
            if (string == null) {
                string = "";
            }
            IMPAX6Tagger iMPAX6Tagger = this;
            synchronized (iMPAX6Tagger) {
                if (!this.study2accNRMap.containsKey(string)) {
                    this.study2accNRMap.put(string, this.accessionNRGenerationSchema.generateAccessionNR(this.accessionNumberSequenceNr));
                    ++this.accessionNumberSequenceNr;
                }
            }
            attributes.setString(524368, VR.SH, this.study2accNRMap.get(string));
        } else if (this.newAccessionNR != null) {
            attributes.setString(524368, VR.SH, this.newAccessionNR);
        }
    }

    public static void main(String[] stringArray) {
        AccessioNRGeneration.setComputerName("viewb267");
        Calendar calendar = Calendar.getInstance();
        calendar.set(2015, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        System.out.println(calendar.getTimeInMillis());
        System.out.println(AccessioNRGeneration.CompressedShort.generateAccessionNR(0));
        System.out.println(AccessioNRGeneration.CompressedShort.generateAccessionNR(1));
        System.out.println(AccessioNRGeneration.CompressedShort.generateAccessionNR(2));
    }

    public static enum AccessioNRGeneration {
        Plain{

            @Override
            void generateAccessionNRImpl(StringBuilder stringBuilder, int n) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(14, n);
                stringBuilder.append('P').append(DATE_FORMAT.format(calendar.getTime()));
            }
        }
        ,
        Compressed{

            @Override
            void generateAccessionNRImpl(StringBuilder stringBuilder, int n) {
                stringBuilder.append("IMP");
                stringBuilder.append(AccessioNRGeneration.trimAndUpper(Long.toString(System.currentTimeMillis() + (long)n, 36), 9));
                stringBuilder.append(workstationStamp);
            }
        }
        ,
        CompressedShort{

            @Override
            void generateAccessionNRImpl(StringBuilder stringBuilder, int n) {
                stringBuilder.append("X");
                stringBuilder.append(AccessioNRGeneration.trimAndUpper(Long.toString(System.currentTimeMillis() - 1420066800000L + (long)n, 36), 8));
                stringBuilder.append(AccessioNRGeneration.trimAndUpper(workstationStamp, 1));
            }
        };

        private static final FastDateFormat DATE_FORMAT;
        private static String workstationStamp;

        static {
            DATE_FORMAT = FastDateFormat.getInstance((String)"yyMMddHHmmssSSS");
            workstationStamp = "NONE";
        }

        public static void setComputerName(String string) {
            byte[] byArray;
            CRC16 cRC16 = new CRC16();
            byte[] byArray2 = byArray = string.getBytes(StandardCharsets.UTF_8);
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte by = byArray2[n2];
                cRC16.update(by);
                ++n2;
            }
            workstationStamp = AccessioNRGeneration.trimAndUpper(Integer.toString(cRC16.value, 36), 4);
        }

        public String generateAccessionNR(int n) {
            StringBuilder stringBuilder = new StringBuilder(20);
            this.generateAccessionNRImpl(stringBuilder, n);
            return stringBuilder.toString();
        }

        abstract void generateAccessionNRImpl(StringBuilder var1, int var2);

        public String toString() {
            switch (this) {
                case Plain: {
                    return "P\"DateTime\"";
                }
                case Compressed: {
                    return "IMP\"DateTimeTimestamp\"\"WorkstationStamp\"";
                }
                case CompressedShort: {
                    return "X\"DateTimeTimestampShort\"\"WorkstationStamp\"";
                }
            }
            return super.toString();
        }

        private static String trimAndUpper(String string, int n) {
            return StringUtils.left((String)string, (int)n).toUpperCase(Locale.ENGLISH);
        }
    }
}

