/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.import_.coercion;

import com.agfa.hap.pacs.impaxee.import_.coercion.ISearchColumns;
import com.agfa.hap.pacs.impaxee.import_.coercion.MWLAttributeCode;
import com.agfa.pacs.listtext.lta.worklist.data.attribute.code.IAttributeCode;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class MWLSearchColumns
implements ISearchColumns {
    private static final MWLSearchColumns INSTANCE = new MWLSearchColumns();
    private final Map<MWLAttributeCode, int[]> paths = new HashMap<MWLAttributeCode, int[]>();
    private final Set<MWLAttributeCode> requiredTags = new LinkedHashSet<MWLAttributeCode>();
    private final Set<Integer> searchableTags = new HashSet<Integer>();

    private MWLSearchColumns() {
        this.addTagPath(ExistenceFlag.REQUIRED, SearchabilityFlag.SEARCHABLE, 0x100010);
        this.addTagPath(ExistenceFlag.REQUIRED, SearchabilityFlag.NOT_SEARCHABLE, 0x100030);
        this.addTagPath(ExistenceFlag.REQUIRED, SearchabilityFlag.NOT_SEARCHABLE, 0x100040);
        this.addTagPath(0x100020);
        this.addTagPath(0x100021);
        this.addTagPath(0x400100, 0, 0x400001);
        this.addTagPath(0x400100, 0, 0x400002);
        this.addTagPath(SearchabilityFlag.NOT_SEARCHABLE, 0x400100, 0, 0x400003);
        this.addTagPath(0x400100, 0, 524384);
        this.addTagPath(0x400100, 0, 0x400006);
        this.addTagPath(SearchabilityFlag.NOT_SEARCHABLE, 0x400100, 0, 0x400007);
        this.addTagPath(0x400100, 0, 0x400010);
        this.addTagPath(0x400100, 0, 0x400009);
        this.addTagPath(0x400100, 0, 3281008);
        this.addTagPath(0x400100, 0, 0x400020);
        this.addTagPath(0x401001);
        this.addTagPath(SearchabilityFlag.NOT_SEARCHABLE, 3280992);
        this.addTagPath(SearchabilityFlag.NOT_SEARCHABLE, 0x20000D);
        this.addTagPath(4198403);
        this.addTagPath(524368);
        this.addTagPath(SearchabilityFlag.NOT_SEARCHABLE, 3280946);
        this.addTagPath(SearchabilityFlag.NOT_SEARCHABLE, 524432);
        this.addTagPath(3670032);
        this.addTagPath(0x380300);
        this.addTagPath(0x380008);
        this.addTagPath(524416);
        this.addTagPath(528512);
        this.addTagPath(3670048);
    }

    public static MWLSearchColumns getInstance() {
        return INSTANCE;
    }

    private void addTagPath(int ... nArray) {
        this.addTagPath(SearchabilityFlag.SEARCHABLE, nArray);
    }

    private void addTagPath(SearchabilityFlag searchabilityFlag, int ... nArray) {
        this.addTagPath(ExistenceFlag.OPTIONAL, searchabilityFlag, nArray);
    }

    private void addTagPath(ExistenceFlag existenceFlag, SearchabilityFlag searchabilityFlag, int ... nArray) {
        MWLAttributeCode mWLAttributeCode = new MWLAttributeCode(nArray[nArray.length - 1]);
        this.paths.put(mWLAttributeCode, nArray);
        if (existenceFlag == ExistenceFlag.REQUIRED) {
            this.requiredTags.add(mWLAttributeCode);
        }
        if (searchabilityFlag == SearchabilityFlag.SEARCHABLE) {
            this.searchableTags.add(mWLAttributeCode.getTag());
        }
    }

    @Override
    public MWLAttributeCode createCode(String string) {
        return new MWLAttributeCode(string);
    }

    @Override
    public int[] getPath(int n) {
        return this.paths.get(new MWLAttributeCode(n));
    }

    public Set<MWLAttributeCode> getAllColumns() {
        return Collections.unmodifiableSet(this.paths.keySet());
    }

    public Iterable<MWLAttributeCode> getRequiredColumns() {
        return this.requiredTags;
    }

    @Override
    public boolean isRequired(IAttributeCode iAttributeCode) {
        return this.requiredTags.contains(iAttributeCode);
    }

    @Override
    public boolean isSearchable(int n) {
        return this.searchableTags.contains(n);
    }

    private static enum ExistenceFlag {
        REQUIRED,
        OPTIONAL;

    }

    private static enum SearchabilityFlag {
        SEARCHABLE,
        NOT_SEARCHABLE;

    }
}

