/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.orm;

import com.agfa.hap.pacs.impaxee.orm.HL7ReplacementVariables;
import com.agfa.hap.pacs.impaxee.orm.ORMChooserInput;
import com.agfa.hap.pacs.impaxee.orm.ORMTextInput;
import com.agfa.pacs.base.util.Dcm4cheUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che3.data.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7MessageTemplate {
    private static final Logger log = LoggerFactory.getLogger(HL7MessageTemplate.class);
    private static final String SEGMENT_DELIMITER = "\r";
    private static final String REPLACEMENT_TAG_START = "${";
    private static final String REPLACEMENT_TAG_END = "}";
    private static final String DISPLAY_OPTION_START = "{";
    private static final String DISPLAY_OPTION_END = "}";
    private static final String REPLACEMENT_INPUT_START = "$[";
    private static final String REPLACEMENT_INPUT_END = "]";
    private static final String INPUT_OPTION_MANDATORY = "(M)";
    private static final String INPUT_OPTION_DEFAULT = "(D)";
    private static final char NAME_SEPARATOR_CHAR = ':';
    private static final char OPTION_SEPARATOR_CHAR = ',';
    private List<String> segments = new ArrayList<String>();
    private List<ORMTextInput> textInputFields;
    private List<ORMChooserInput> chooserInputFields;

    private HL7MessageTemplate() {
    }

    public static HL7MessageTemplate parseHL7(InputStream inputStream, Charset charset) {
        HL7MessageTemplate hL7MessageTemplate = new HL7MessageTemplate();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() <= 0) continue;
                hL7MessageTemplate.addSegment(string);
            }
        }
        catch (IOException iOException) {
            log.error("Failed to read HL7 message template", (Throwable)iOException);
        }
        return hL7MessageTemplate;
    }

    public void addSegment(String string) {
        this.segments.add(string);
    }

    public String createHL7Message(Attributes attributes, Properties properties, List<ORMTextInput> list, List<ORMChooserInput> list2) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = this.segments.iterator();
        while (iterator.hasNext()) {
            int n;
            CharSequence charSequence;
            String string;
            String string2 = string = iterator.next();
            Object object = HL7ReplacementVariables.values();
            int n2 = ((HL7ReplacementVariables[])object).length;
            int n3 = 0;
            while (n3 < n2) {
                HL7ReplacementVariables hL7ReplacementVariables = object[n3];
                if (string.indexOf(hL7ReplacementVariables.getName()) > -1) {
                    charSequence = hL7ReplacementVariables.getReplacement(attributes, properties);
                    if (charSequence == null) {
                        throw new Exception("Unable to replace variable " + hL7ReplacementVariables.getName());
                    }
                    string2 = StringUtils.replace((String)string2, (String)hL7ReplacementVariables.getName(), (String)charSequence);
                }
                ++n3;
            }
            while ((n = string2.indexOf(REPLACEMENT_TAG_START)) != -1) {
                n3 = string2.indexOf("}", n);
                if (n3 == -1) {
                    log.error("Template contains non-terminated replacement tag.");
                    break;
                }
                String string3 = string2.substring(n + REPLACEMENT_TAG_START.length(), n3);
                object = this.getReplacementVariable(attributes, string3);
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(string2.substring(0, n));
                ((StringBuilder)charSequence).append((String)object);
                ((StringBuilder)charSequence).append(string2.substring(n3 + "}".length()));
                string2 = ((StringBuilder)charSequence).toString();
            }
            while ((n = string2.indexOf(REPLACEMENT_INPUT_START)) != -1) {
                n3 = string2.indexOf(REPLACEMENT_INPUT_END, n);
                if (n3 == -1) {
                    log.error("Template contains non-terminated replacement tag.");
                    break;
                }
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append(string2.substring(0, n));
                int n4 = string2.indexOf(58);
                if (n4 == -1 || n4 < n || n4 > n3) {
                    charSequence = string2.substring(n + REPLACEMENT_INPUT_START.length(), n3);
                    if (((String)charSequence).endsWith(INPUT_OPTION_MANDATORY)) {
                        charSequence = ((String)charSequence).substring(0, ((String)charSequence).length() - INPUT_OPTION_MANDATORY.length());
                    }
                    for (ORMTextInput oRMTextInput : list) {
                        if (!oRMTextInput.getName().equals(charSequence)) continue;
                        String string3 = oRMTextInput.getValue();
                        if (string3 == null) break;
                        stringBuilder2.append(this.removeHL7ControlCharacters(string3.trim()));
                        break;
                    }
                } else {
                    charSequence = string2.substring(n + REPLACEMENT_INPUT_START.length(), n4);
                    for (ORMChooserInput oRMChooserInput : list2) {
                        if (!oRMChooserInput.getName().equals(charSequence)) continue;
                        stringBuilder2.append(oRMChooserInput.getSelectedOption());
                        break;
                    }
                }
                stringBuilder2.append(string2.substring(n3 + REPLACEMENT_INPUT_END.length()));
                string2 = stringBuilder2.toString();
            }
            stringBuilder.append(string2);
            stringBuilder.append(SEGMENT_DELIMITER);
        }
        return stringBuilder.toString();
    }

    private String getReplacementVariable(Attributes attributes, String string) {
        String string2;
        if (Character.isDigit(string.charAt(0))) {
            try {
                string2 = HL7MessageTemplate.getReplacementTag(attributes, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error("Template contains malformed replacement tag.", (Throwable)illegalArgumentException);
                throw illegalArgumentException;
            }
        } else {
            string2 = System.getProperty(string);
        }
        if (string2 == null) {
            string2 = "";
            log.warn("No value for replacement {}, using empty string.", (Object)string);
        }
        return string2;
    }

    private String removeHL7ControlCharacters(String string) {
        return StringUtils.replaceChars((String)string, (String)"|^", (String)"");
    }

    public List<ORMTextInput> getTextInputFields() {
        this.initTextInputFields();
        ArrayList<ORMTextInput> arrayList = new ArrayList<ORMTextInput>(this.textInputFields.size());
        for (ORMTextInput oRMTextInput : this.textInputFields) {
            arrayList.add(new ORMTextInput(oRMTextInput));
        }
        return arrayList;
    }

    private void initTextInputFields() {
        if (this.textInputFields == null) {
            this.textInputFields = new ArrayList<ORMTextInput>();
            block0: for (String string : this.segments) {
                int n;
                int n2 = 0;
                while ((n = string.indexOf(REPLACEMENT_INPUT_START, n2)) != -1) {
                    int n3 = string.indexOf(REPLACEMENT_INPUT_END, n);
                    if (n3 == -1) {
                        log.error("Template contains non-terminated replacement tag.");
                        continue block0;
                    }
                    String string2 = string.substring(n + REPLACEMENT_INPUT_START.length(), n3);
                    if (string2.indexOf(58) == -1) {
                        boolean bl = true;
                        if (string2.endsWith(INPUT_OPTION_MANDATORY)) {
                            bl = false;
                            string2 = string2.substring(0, string2.length() - INPUT_OPTION_MANDATORY.length());
                        }
                        if (!HL7MessageTemplate.containsTextInput(this.textInputFields, string2, bl)) {
                            this.textInputFields.add(new ORMTextInput(string2, bl));
                        }
                    }
                    n2 = n3;
                }
            }
        }
    }

    private static boolean containsTextInput(List<ORMTextInput> list, String string, boolean bl) {
        for (ORMTextInput oRMTextInput : list) {
            if (!oRMTextInput.getName().equals(string) || oRMTextInput.isOptional() != bl) continue;
            return true;
        }
        return false;
    }

    public List<ORMChooserInput> getChooserInputFields() {
        this.initChooserInputFields();
        ArrayList<ORMChooserInput> arrayList = new ArrayList<ORMChooserInput>(this.chooserInputFields.size());
        for (ORMChooserInput oRMChooserInput : this.chooserInputFields) {
            arrayList.add(new ORMChooserInput(oRMChooserInput));
        }
        return arrayList;
    }

    private void initChooserInputFields() {
        if (this.chooserInputFields == null) {
            this.chooserInputFields = new ArrayList<ORMChooserInput>();
            block0: for (String string : this.segments) {
                int n;
                int n2 = 0;
                while ((n = string.indexOf(REPLACEMENT_INPUT_START, n2)) != -1) {
                    int n3 = string.indexOf(REPLACEMENT_INPUT_END, n);
                    if (n3 == -1) {
                        log.error("Template contains non-terminated replacement input.");
                        continue block0;
                    }
                    String string2 = string.substring(n + REPLACEMENT_INPUT_START.length(), n3);
                    int n4 = string2.indexOf(58);
                    if (n4 >= 0) {
                        String string3 = string2.substring(0, n4);
                        String[] stringArray = StringUtils.split((String)string2.substring(n4 + 1), (char)',');
                        String[] stringArray2 = new String[stringArray.length];
                        int n5 = 0;
                        int n6 = 0;
                        while (n6 < stringArray.length) {
                            int n7 = stringArray[n6].indexOf(DISPLAY_OPTION_START);
                            int n8 = stringArray[n6].indexOf("}");
                            if (n7 == -1 && n8 == -1) {
                                if (stringArray[n6].endsWith(INPUT_OPTION_DEFAULT)) {
                                    stringArray[n6] = stringArray[n6].substring(0, stringArray[n6].length() - INPUT_OPTION_DEFAULT.length());
                                    n5 = n6;
                                    break;
                                }
                            } else if (n7 >= 0 && n8 >= 0) {
                                String[] stringArray3 = StringUtils.split((String)stringArray[n6], (String)DISPLAY_OPTION_START);
                                if (stringArray3.length != 2) {
                                    log.error("Template contains an invalid number of display options for a message option or a non-terminated display options expression.");
                                    break;
                                }
                                stringArray[n6] = stringArray3[0];
                                String string4 = stringArray3[1];
                                if (string4.endsWith(INPUT_OPTION_DEFAULT)) {
                                    string4 = string4.substring(0, string4.length() - INPUT_OPTION_DEFAULT.length());
                                    n5 = n6;
                                }
                                if (string4.endsWith("}")) {
                                    string4 = string4.substring(0, string4.length() - "}".length());
                                }
                                stringArray2[n6] = string4;
                            }
                            ++n6;
                        }
                        if (!HL7MessageTemplate.containsChooserInput(this.chooserInputFields, string3, stringArray, n5)) {
                            this.chooserInputFields.add(new ORMChooserInput(string3, stringArray, stringArray2, n5));
                        }
                    }
                    n2 = n3;
                }
            }
        }
    }

    private static boolean containsChooserInput(List<ORMChooserInput> list, String string, String[] stringArray, int n) {
        for (ORMChooserInput oRMChooserInput : list) {
            if (!oRMChooserInput.getName().equals(string) || oRMChooserInput.getValue() != n || oRMChooserInput.getOptions().length != stringArray.length) continue;
            boolean bl = true;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (!stringArray[n2].equals(oRMChooserInput.getOptions()[n2])) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public boolean containsInputFields() {
        this.initTextInputFields();
        this.initChooserInputFields();
        return this.textInputFields.size() + this.chooserInputFields.size() > 0;
    }

    private static String getReplacementTag(Attributes attributes, String string) {
        String[] stringArray = StringUtils.split((String)string, (char)'\\');
        if (stringArray.length != 1 && stringArray.length % 3 != 0) {
            throw new IllegalArgumentException("Tag String contains the wrong amount of parts");
        }
        int[] nArray = new int[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            if (n % 2 == 0) {
                nArray[n] = HL7MessageTemplate.getTagNumber(stringArray[n]);
            } else {
                try {
                    nArray[n] = Integer.parseInt(stringArray[n]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Malformed tag string, expected number at position " + n);
                }
            }
            ++n;
        }
        return Dcm4cheUtils.getString((int[])nArray, (Attributes)attributes);
    }

    private static int getTagNumber(String string) {
        if (string.contains(",")) {
            try {
                string = string.replace(",", "");
                return (int)Long.parseLong(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Could not parse dicom tag: " + string);
            }
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Could not parse dicom tag: " + string);
        }
    }
}

