/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.orm;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che3.data.Attributes;

public enum HL7ReplacementVariables {
    ACCESSION_NUMBER("$AccessionNumber"),
    DATE_AND_TIME_OF_MESSAGE("$DateAndTimeOfMessage"),
    STUDY_DATE("$StudyDate"),
    ISSUER_OF_PATIENT_ID("$IssuerOfPatientID"),
    PATIENT_ID("$PatientID"),
    PATIENT_NAME("$PatientName"),
    PATIENT_BIRTH_DATE("$PatientBirthDate"),
    PATIENT_SEX("$PatientSex"),
    STUDY_INSTANCE_UID("$StudyInstanceUID"),
    ENCOUNTER_ID("$EncounterID"),
    ENCOUNTER_EPISODE_OF_CARE_ID("$EncounterEpisodeOfCareID"),
    ENCOUNTER_ORG_UNIT1("$EncounterOrgUnit1"),
    ENCOUNTER_ORG_UNIT2("$EncounterOrgUnit2"),
    USER("$OrderUser"),
    MODALITIES("$Modalities");

    private static final String DATE_TIME_FORMAT = "yyyyMMddHHmmss";
    private static final String DATE_FORMAT = "yyyyMMdd";
    private final String varName;

    private HL7ReplacementVariables(String string2) {
        this.varName = string2;
    }

    public String getName() {
        return this.varName;
    }

    public String getReplacement(Attributes attributes, Properties properties) {
        String string = null;
        switch (this) {
            case ACCESSION_NUMBER: {
                string = attributes.getString(524368);
                if (string != null) break;
                string = "";
                break;
            }
            case DATE_AND_TIME_OF_MESSAGE: {
                string = new SimpleDateFormat(DATE_TIME_FORMAT).format(Calendar.getInstance().getTime());
                break;
            }
            case STUDY_DATE: {
                string = HL7ReplacementVariables.getFormattedDate(attributes.getDate(524320));
                break;
            }
            case ISSUER_OF_PATIENT_ID: {
                string = attributes.getString(0x100021);
                if (string != null) break;
                string = "";
                break;
            }
            case PATIENT_ID: {
                string = attributes.getString(0x100020);
                break;
            }
            case PATIENT_NAME: {
                string = attributes.getString(0x100010);
                break;
            }
            case PATIENT_BIRTH_DATE: {
                string = HL7ReplacementVariables.getFormattedDate(attributes.getDate(0x100030));
                break;
            }
            case PATIENT_SEX: {
                string = attributes.getString(0x100040);
                break;
            }
            case STUDY_INSTANCE_UID: {
                string = attributes.getString(0x20000D);
                break;
            }
            case ENCOUNTER_ID: 
            case ENCOUNTER_EPISODE_OF_CARE_ID: 
            case ENCOUNTER_ORG_UNIT1: 
            case ENCOUNTER_ORG_UNIT2: 
            case USER: {
                string = properties.getProperty(this.name());
                break;
            }
            case MODALITIES: {
                string = properties.getProperty(this.name());
                if (string != null) break;
                string = StringUtils.join((Object[])attributes.getStrings(524385), (String)",");
            }
        }
        return string;
    }

    private static String getFormattedDate(Date date) {
        if (date != null) {
            return new SimpleDateFormat(DATE_FORMAT).format(date);
        }
        return "";
    }
}

