/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.orm;

import com.agfa.hap.pacs.impaxee.orm.HL7MessageTemplate;
import com.agfa.hap.pacs.impaxee.orm.IHL7TemplateProvider;
import com.agfa.hap.pacs.impaxee.orm.ORMChooserInput;
import com.agfa.hap.pacs.impaxee.orm.ORMTextInput;
import com.agfa.pacs.data.hl7.AcknowledgementCode;
import com.agfa.pacs.data.hl7.MLLPSender;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.hl7.HL7Message;
import org.dcm4che3.util.UIDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderMessage {
    private static final Logger log = LoggerFactory.getLogger(OrderMessage.class);
    public static final String SEND_HL7_ORM = "sendHL7ORM";
    public static final String HL7_ORM_TEMPLATE = "hl7ORMTemplate";
    public static final String HL7_ORM_TARGET_HOST = "hl7ORMTargetHost";
    public static final String HL7_ORM_TARGET_PORT = "hl7ORMTargetPort";
    public static final String HL7_ORM_TEXT_INPUT_FIELDS = "hl7ORMTextInputFields";
    public static final String HL7_ORM_CHOOSER_INPUT_FIELDS = "hl7ORMChooserInputFields";
    private boolean doProcessORM = false;
    private String hl7ORMTemplate;
    private String hl7ORMTargetHost;
    private int hl7ORMTargetPort;
    private HashSet<String> importedStudies;
    private List<ORMTextInput> textInputFields;
    private List<ORMChooserInput> chooserInputFields;
    private Properties properties;
    private int hl7MessageDelay;
    private IHL7TemplateProvider orderMessageManager;
    private String hl7Charset;

    public OrderMessage(IHL7TemplateProvider iHL7TemplateProvider, int n, String string) {
        this.orderMessageManager = iHL7TemplateProvider;
        this.hl7MessageDelay = n;
        this.hl7Charset = string;
    }

    public void prepare(Properties properties) {
        this.doProcessORM = Boolean.parseBoolean(Objects.toString(properties.get(SEND_HL7_ORM)));
        if (this.doProcessORM) {
            this.importedStudies = new HashSet();
            this.hl7ORMTemplate = properties.getProperty(HL7_ORM_TEMPLATE);
            this.hl7ORMTargetHost = properties.getProperty(HL7_ORM_TARGET_HOST);
            String string = properties.getProperty(HL7_ORM_TARGET_PORT);
            this.hl7ORMTargetPort = string != null && string.length() > 0 ? Integer.parseInt(properties.getProperty(HL7_ORM_TARGET_PORT)) : -1;
            if (this.hl7ORMTemplate == null || this.hl7ORMTargetHost == null || this.hl7ORMTargetHost.length() == 0 || this.hl7ORMTargetPort == -1) {
                this.doProcessORM = false;
                log.error("Some settings are missing, Unable to send HL7 ORM message to server");
            }
            this.textInputFields = (List)properties.get(HL7_ORM_TEXT_INPUT_FIELDS);
            this.chooserInputFields = (List)properties.get(HL7_ORM_CHOOSER_INPUT_FIELDS);
            this.properties = properties;
        }
    }

    public boolean doProcessORM() {
        return this.doProcessORM;
    }

    public void process(Attributes attributes) throws ORMProcessingException {
        String string;
        if (attributes.getString(0x20000D) == null) {
            if (!this.importedStudies.isEmpty()) {
                attributes.setString(0x20000D, VR.UI, this.importedStudies.iterator().next());
            } else {
                attributes.setString(0x20000D, VR.UI, UIDUtils.createUID());
            }
        }
        if (!this.importedStudies.contains(string = attributes.getString(0x20000D))) {
            this.importedStudies.add(string);
            try {
                this.sendHL7Message(this.orderMessageManager.getMessageTemplate(this.hl7ORMTemplate), attributes);
                Thread.sleep(this.hl7MessageDelay);
            }
            catch (Exception exception) {
                throw new ORMProcessingException("Failed to send HL7 ORM message.", exception);
            }
        }
    }

    public void cleanup() {
        this.importedStudies = null;
        this.textInputFields = null;
        this.chooserInputFields = null;
        this.properties = null;
    }

    private void sendHL7Message(HL7MessageTemplate hL7MessageTemplate, Attributes attributes) throws Exception {
        MLLPSender mLLPSender = new MLLPSender(this.hl7ORMTargetHost, this.hl7ORMTargetPort);
        String string = hL7MessageTemplate.createHL7Message(attributes, this.properties, this.textInputFields, this.chooserInputFields);
        HL7Message hL7Message = mLLPSender.sendMessage(string, this.hl7Charset);
        AcknowledgementCode acknowledgementCode = AcknowledgementCode.fromHL7Message(hL7Message);
        if (acknowledgementCode != AcknowledgementCode.AA) {
            log.error("Received Error Response on HL7 ORM^O01 to {}:{}: {}", new Object[]{this.hl7ORMTargetHost, this.hl7ORMTargetPort, acknowledgementCode.getDescription()});
            log.info("Response:\n{}", (Object)hL7Message);
        } else {
            log.info("HL7 ORM message successfully sent ({})", (Object)acknowledgementCode);
        }
    }

    public static class ORMProcessingException
    extends Exception {
        public ORMProcessingException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

