/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.pattern;

import com.agfa.hap.pacs.impaxee.pattern.IntAttributesPattern;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.dcm4che3.data.Attributes;

public class ImageNumberAttributesPattern
extends IntAttributesPattern {
    private final ThreadLocal<NumberFormat> frameNumberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat("000");
        }
    };

    public ImageNumberAttributesPattern() {
        super("imageno", 2097171, "0000");
    }

    @Override
    public String getReplacementString(Attributes attributes, int n) {
        String string = super.getReplacementString(attributes, n);
        if (string == null) {
            return null;
        }
        if (attributes.getInt(0x280008, 1) == 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append('-');
        stringBuilder.append(this.frameNumberFormat.get().format(n));
        return stringBuilder.toString();
    }
}

