/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.reports;

import com.agfa.hap.pacs.data.DateUtilities;
import com.agfa.hap.pacs.impaxee.reports.IReportMetaData;
import com.agfa.pacs.listtext.dicomobject.type.CompletionFlag;
import com.agfa.pacs.listtext.dicomobject.type.VerificationFlag;
import java.util.Date;
import org.dcm4che3.data.Attributes;

abstract class AbstractReportMetaData
implements IReportMetaData {
    private final Attributes reportAttributes;

    AbstractReportMetaData(Attributes attributes) {
        this.reportAttributes = attributes;
    }

    @Override
    public String getHtmlDigest(IReportMetaData.IReportFieldTranslator iReportFieldTranslator) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><body>");
        stringBuilder.append(this.toString(iReportFieldTranslator));
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }

    @Override
    public Attributes getReportAttributes() {
        return this.reportAttributes;
    }

    @Override
    public Date getCreationDateTime() {
        return this.getCreationDateTimeInt();
    }

    public String toString() {
        return this.toString(DefaultReportFieldFormatter.INSTANCE);
    }

    @Override
    public String toString(IReportMetaData.IReportFieldTranslator iReportFieldTranslator) {
        String string = this.getTitle(iReportFieldTranslator);
        Date date = this.getCreationDate();
        CompletionFlag completionFlag = this.getCompletionFlag();
        VerificationFlag verificationFlag = this.getVerificationFlag();
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
        }
        if (date != null || completionFlag != null || verificationFlag != null) {
            stringBuilder.append(" (");
            if (date != null) {
                stringBuilder.append(iReportFieldTranslator.formatDate(date));
                if (completionFlag != null || verificationFlag != null) {
                    stringBuilder.append(", ");
                }
            }
            if (completionFlag != null) {
                stringBuilder.append(iReportFieldTranslator.translateCompletionFlag(completionFlag));
                if (verificationFlag != null) {
                    stringBuilder.append(", ");
                }
            }
            if (verificationFlag != null) {
                stringBuilder.append(iReportFieldTranslator.translateVerificationFlag(verificationFlag));
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    private Date getCreationDateTimeInt() {
        Date date = this.getCreationDate();
        Date date2 = this.getCreationTime();
        if (date != null && date2 != null) {
            return DateUtilities.createDateTime((Date)date, (Date)date2);
        }
        if (date2 == null) {
            return date;
        }
        return date;
    }

    static enum DefaultReportFieldFormatter implements IReportMetaData.IReportFieldTranslator
    {
        INSTANCE;


        @Override
        public String getDefaultTitle() {
            return null;
        }

        @Override
        public String formatDate(Date date) {
            return String.valueOf(date);
        }

        @Override
        public String formatDateTime(Date date) {
            return String.valueOf(date);
        }

        @Override
        public String translateCompletionFlag(CompletionFlag completionFlag) {
            return String.valueOf(completionFlag);
        }

        @Override
        public String translateVerificationFlag(VerificationFlag verificationFlag) {
            return String.valueOf(verificationFlag);
        }
    }
}

