/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.reports;

import com.agfa.hap.pacs.impaxee.reports.IBasicReportMetaData;
import com.agfa.hap.pacs.impaxee.reports.ReportType;
import com.agfa.pacs.listtext.dicomobject.type.VerificationFlag;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;

public class ReportMetaDataComparatorFactory {
    private static final ReportMetaDataComparatorFactory INSTANCE = new ReportMetaDataComparatorFactory();
    private static final Set<ReportType> RADIOLOGY_REPORT_TYPES = EnumSet.of(ReportType.OrbisReport, ReportType.CDAReport, ReportType.PDFReport, ReportType.StructuredReport);

    private ReportMetaDataComparatorFactory() {
    }

    public static ReportMetaDataComparatorFactory getInstance() {
        return INSTANCE;
    }

    public Comparator<IBasicReportMetaData> createReportComparator() {
        return new DefaultComparator();
    }

    private static abstract class AbstractComparator
    implements Comparator<IBasicReportMetaData> {
        private AbstractComparator() {
        }

        @Override
        public int compare(IBasicReportMetaData iBasicReportMetaData, IBasicReportMetaData iBasicReportMetaData2) {
            boolean bl = this.isRadiologyReport(iBasicReportMetaData);
            boolean bl2 = this.isRadiologyReport(iBasicReportMetaData2);
            if (!bl && bl2) {
                return 1;
            }
            if (bl && !bl2) {
                return -1;
            }
            return 0;
        }

        private boolean isRadiologyReport(IBasicReportMetaData iBasicReportMetaData) {
            return RADIOLOGY_REPORT_TYPES.contains((Object)iBasicReportMetaData.getType());
        }
    }

    private static class DefaultComparator
    extends AbstractComparator {
        private DefaultComparator() {
        }

        @Override
        public int compare(IBasicReportMetaData iBasicReportMetaData, IBasicReportMetaData iBasicReportMetaData2) {
            if (iBasicReportMetaData == iBasicReportMetaData2) {
                return 0;
            }
            int n = super.compare(iBasicReportMetaData, iBasicReportMetaData2);
            if (n != 0) {
                return n;
            }
            Date date = iBasicReportMetaData.getCreationDateTime();
            Date date2 = iBasicReportMetaData2.getCreationDateTime();
            int n2 = ObjectUtils.compare((Comparable)date2, (Comparable)date);
            if (n2 == 0) {
                VerificationFlag verificationFlag = iBasicReportMetaData.getVerificationFlag();
                VerificationFlag verificationFlag2 = iBasicReportMetaData2.getVerificationFlag();
                return ObjectUtils.compare((Comparable)verificationFlag, (Comparable)verificationFlag2, (boolean)true);
            }
            return n2;
        }
    }
}

