/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.reports;

import com.agfa.hap.pacs.impaxee.reports.IReportMetaData;
import com.agfa.hap.pacs.impaxee.reports.OrbisReportMetaData;
import com.agfa.hap.pacs.impaxee.reports.ReportType;
import com.agfa.hap.pacs.impaxee.reports.StructuredReportMetaData;
import com.agfa.hap.pacs.impaxee.reports.TeachingFileReportMetaData;
import org.dcm4che3.data.Attributes;

public class ReportMetaDataFactory {
    public static boolean supportsReport(Attributes attributes) {
        ReportType reportType = ReportType.getReportType(attributes, true);
        return reportType != null;
    }

    public static IReportMetaData createReportMetaData(Attributes attributes, boolean bl) throws UnsupportedReportTypeException {
        ReportType reportType = ReportType.getReportType(attributes, bl);
        if (reportType != null) {
            switch (reportType) {
                case OrbisReport: {
                    return new OrbisReportMetaData(attributes);
                }
                case TeachingFileReport: {
                    return new TeachingFileReportMetaData(attributes);
                }
                case DoseReport: 
                case MammoPreprocessingReport: 
                case CDAReport: 
                case StructuredReport: 
                case TomTecStructuredReport: 
                case PDFReport: 
                case ElectronicFilmPresentation: {
                    return new StructuredReportMetaData(attributes, reportType);
                }
            }
        } else {
            return null;
        }
        throw new UnsupportedReportTypeException(reportType);
    }

    public static class UnsupportedReportTypeException
    extends Exception {
        public UnsupportedReportTypeException(ReportType reportType) {
            super("Report type not supported: " + (Object)((Object)reportType));
        }
    }
}

