/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.reports;

import com.agfa.hap.pacs.data.FileImportUtils;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.code.CodeGlossary;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che3.data.Attributes;

public enum ReportType {
    DoseReport(new String[]{"1.2.840.10008.5.1.4.1.1.88.67"}),
    OrbisReport(new String[]{"1.2.840.10008.5.1.4.1.1.88.11", "1.2.840.10008.5.1.4.1.1.88.22", "1.2.840.10008.5.1.4.1.1.88.33"}),
    TeachingFileReport(new String[]{"1.2.840.10008.5.1.4.1.1.88.11", "1.2.840.10008.5.1.4.1.1.88.22"}),
    MammoPreprocessingReport("1.2.840.10008.5.1.4.1.1.88.11"),
    CDAReport(new String[]{"1.2.840.10008.5.1.4.1.1.104.2"}),
    StructuredReport(new String[]{"1.2.840.10008.5.1.4.1.1.88.11", "1.2.840.10008.5.1.4.1.1.88.22", "1.2.840.10008.5.1.4.1.1.88.33", "1.2.840.10008.5.1.4.1.1.88.40"}),
    TomTecStructuredReport(new String[]{"1.2.840.10008.5.1.4.1.1.88.33"}),
    PDFReport("1.2.840.10008.5.1.4.1.1.104.1"),
    ElectronicFilmPresentation("1.2.840.10008.5.1.4.1.1.88.22");

    private static final Code TEACHING_FILE_CODE;
    private static final Code ELECTRONIC_FILM_PRESENTATION_CODE;
    private static final String TOMTEC_MANUFACTURER = "TomTec";
    private String[] sopClasses;

    static {
        TEACHING_FILE_CODE = new Code("IHERADTF", "TCE006", null);
        ELECTRONIC_FILM_PRESENTATION_CODE = new Code("99GEMS", "AWVF-0001", null);
    }

    private ReportType(String[] stringArray) {
        this.sopClasses = stringArray;
    }

    private ReportType(String string2) {
        this(new String[]{string2});
    }

    public static ReportType getReportType(Attributes attributes, boolean bl) {
        if (attributes != null) {
            String string = attributes.getString(524400);
            String string2 = ReportType.getSOPClassUID(attributes);
            Code code = Code.create((Attributes)attributes, (int)4235331);
            if (Objects.equals("1.2.840.10008.5.1.4.1.1.88.67", string2)) {
                return DoseReport;
            }
            if (Objects.equals("1.2.840.10008.5.1.4.1.1.104.2", string2)) {
                return CDAReport;
            }
            if (Objects.equals(code, CodeGlossary.MAMMO_PREPROCESSING_REPORT)) {
                return MammoPreprocessingReport;
            }
            if (Arrays.asList(ReportType.TeachingFileReport.sopClasses).contains(string2) && Objects.equals(TEACHING_FILE_CODE, code)) {
                return TeachingFileReport;
            }
            if (Arrays.asList(ReportType.ElectronicFilmPresentation.sopClasses).contains(string2) && Objects.equals(ELECTRONIC_FILM_PRESENTATION_CODE, code)) {
                return ElectronicFilmPresentation;
            }
            if (Arrays.asList(ReportType.OrbisReport.sopClasses).contains(string2) && StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)"AGFA")) {
                return OrbisReport;
            }
            if (Arrays.asList(ReportType.TomTecStructuredReport.sopClasses).contains(string2) && StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)TOMTEC_MANUFACTURER)) {
                return TomTecStructuredReport;
            }
            if (Arrays.asList(ReportType.StructuredReport.sopClasses).contains(string2) && !"QDOC".equalsIgnoreCase(string)) {
                return StructuredReport;
            }
            if (Objects.equals("1.2.840.10008.5.1.4.1.1.104.1", string2)) {
                if (bl) {
                    if (!FileImportUtils.isFileImport((Attributes)attributes)) {
                        return PDFReport;
                    }
                } else {
                    return PDFReport;
                }
            }
        }
        return null;
    }

    private static String getSOPClassUID(Attributes attributes) {
        return attributes.getString(524310);
    }
}

