/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.studyshare;

import com.agfa.hap.pacs.impaxee.data.IAuthenticationData;
import com.agfa.hap.pacs.impaxee.studyshare.IStudyShareConfig;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractStudyShareConfig
implements IStudyShareConfig {
    private static final String DEFAULT_USER_ID = "R20_ExtFrei";

    @Override
    public boolean isValid() {
        return this.isValidArchive() && this.isValidServer() && this.isValidAuthenticationData();
    }

    private boolean isValidArchive() {
        return !this.isSeparateArchiveUsed() || StringUtils.isNotBlank((CharSequence)this.getDestinationAET());
    }

    private boolean isValidServer() {
        return StringUtils.isNotBlank((CharSequence)this.getInternalURL()) && StringUtils.isNotBlank((CharSequence)this.getExternalBaseURL());
    }

    private boolean isValidAuthenticationData() {
        IAuthenticationData iAuthenticationData = this.getAuthenticationData();
        return iAuthenticationData != null && StringUtils.isNotBlank((CharSequence)iAuthenticationData.getUserName()) && StringUtils.isNotBlank((CharSequence)iAuthenticationData.getPassword());
    }

    @Override
    public Map<String, String> getAuthenticationParameters() {
        IAuthenticationData iAuthenticationData = this.getAuthenticationData();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("login", "Login");
        hashMap.put("j_username", iAuthenticationData.getUserName());
        hashMap.put("j_password", iAuthenticationData.getPassword());
        return hashMap;
    }

    protected abstract IAuthenticationData getAuthenticationData();

    @Override
    public String getUserId() {
        String string = this.getUserIdImpl();
        if (string == null || string.trim().isEmpty()) {
            string = DEFAULT_USER_ID;
        }
        return string;
    }

    protected abstract String getUserIdImpl();
}

