/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.pacs.impaxee.studyshare.task;

import com.agfa.hap.pacs.impaxee.HTTPHeaderUtils;
import com.agfa.hap.pacs.impaxee.studyshare.IPermissionTask;
import com.agfa.hap.pacs.impaxee.studyshare.IStudyShareData;
import com.agfa.hap.pacs.impaxee.studyshare.IStudySharePDFOptions;
import com.agfa.hap.pacs.impaxee.studyshare.IStudyShareSettings;
import com.agfa.hap.pacs.impaxee.studyshare.StudyShareParameter;
import com.agfa.hap.pacs.impaxee.studyshare.StudySharePermission;
import com.agfa.hap.pacs.impaxee.studyshare.task.AbstractStudyShareTask;
import com.agfa.pacs.base.util.PersonNameUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Date;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.PersonName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPDFCreationTask<T>
extends AbstractStudyShareTask<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractPDFCreationTask.class);
    private static final Pattern FORBIDDEN_XML_CHARACTERS = Pattern.compile("<|>|&");
    private final IPermissionTask permissionsTask;
    private final IStudySharePDFOptions pdfOptions;

    protected AbstractPDFCreationTask(IPermissionTask iPermissionTask, IStudySharePDFOptions iStudySharePDFOptions) {
        super(iPermissionTask.getConfig());
        this.permissionsTask = iPermissionTask;
        this.pdfOptions = iStudySharePDFOptions;
    }

    @Override
    public boolean execute() {
        if (this.permissionsTask.getResult() == null) {
            log.warn("No study permission data available.");
            return false;
        }
        return super.execute();
    }

    @Override
    String createSessionCookie() {
        return ((IStudyShareData)this.permissionsTask.getResult()).getSessionCookie();
    }

    @Override
    String getRequestURLPath() {
        return "portal/servlet/PdfServlet";
    }

    @Override
    Map<StudyShareParameter, String> getRequestParameters() {
        IStudyShareData iStudyShareData = (IStudyShareData)this.permissionsTask.getResult();
        EnumMap<StudyShareParameter, String> enumMap = new EnumMap<StudyShareParameter, String>(StudyShareParameter.class);
        enumMap.put(StudyShareParameter.ACTION, "eaPdf");
        enumMap.put(StudyShareParameter.PATIENT_BIRTHDATE, iStudyShareData.getPatientBirthDate());
        enumMap.put(StudyShareParameter.PDF_DATA, this.createPDFData(iStudyShareData));
        enumMap.put(StudyShareParameter.QR_CODE, Boolean.toString(this.pdfOptions.isQRCodeEnabled()));
        enumMap.put(StudyShareParameter.QR_CODE_SERVLET_URL, this.getInternalURL("portal/servlet/QrCodeServlet?"));
        return enumMap;
    }

    @Override
    AbstractStudyShareTask.RetrySettings getRetrySettings() {
        return AbstractStudyShareTask.RetrySettings.DEFAULT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    T readResponse(HttpURLConnection httpURLConnection) throws IOException {
        T t = this.createResult(HTTPHeaderUtils.readFileName(httpURLConnection));
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            InputStream inputStream = httpURLConnection.getInputStream();
            try {
                T t2;
                block14: {
                    OutputStream outputStream = this.createOutputStream(t);
                    try {
                        AbstractPDFCreationTask.copyStream(inputStream, outputStream);
                        t2 = t;
                        return t2;
                    }
                    finally {
                        if (outputStream == null) break block14;
                        outputStream.close();
                    }
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                return t2;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    protected abstract T createResult(String var1) throws IOException;

    protected abstract OutputStream createOutputStream(T var1) throws IOException;

    private static long copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 0x100000;
        byte[] byArray = new byte[n3];
        while ((n = inputStream.read(byArray, 0, n3)) >= 0) {
            outputStream.write(byArray, 0, n);
            n2 += n;
        }
        return n2;
    }

    private String createPDFData(IStudyShareData iStudyShareData) {
        IStudyShareSettings iStudyShareSettings = (IStudyShareSettings)this.permissionsTask.getResult();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuilder.append("<pdfData>");
        stringBuilder.append("<instDescription>");
        stringBuilder.append(this.removeForbiddenXmlCharacters(this.pdfOptions.getInstitutionName()));
        stringBuilder.append("</instDescription>");
        String string = this.getConfiguredPatientIdentification();
        if (string != null) {
            stringBuilder.append("<patientname>");
            stringBuilder.append(string);
            stringBuilder.append("</patientname>");
        }
        stringBuilder.append("<princDescription>");
        stringBuilder.append(this.removeForbiddenXmlCharacters(this.pdfOptions.getDepartmentName()));
        stringBuilder.append("</princDescription>");
        stringBuilder.append("<access_code>");
        stringBuilder.append(iStudyShareData.getAccessCode());
        stringBuilder.append("</access_code>");
        stringBuilder.append("<permission>");
        stringBuilder.append(this.getString(iStudyShareSettings.getPermission()));
        stringBuilder.append("</permission>");
        stringBuilder.append("<expirationDate>");
        stringBuilder.append(StudyShareParameter.formatDate(iStudyShareSettings.getExpirationDate()));
        stringBuilder.append("</expirationDate>");
        stringBuilder.append("<baseUrl>");
        stringBuilder.append(this.config.getExternalBaseURL());
        stringBuilder.append("</baseUrl>");
        stringBuilder.append("<date>");
        stringBuilder.append(StudyShareParameter.formatDate(new Date()));
        stringBuilder.append("</date>");
        stringBuilder.append("<studyCount>");
        stringBuilder.append(iStudyShareData.getStudyCount());
        stringBuilder.append("</studyCount>");
        stringBuilder.append("<defaultText/>");
        stringBuilder.append("</pdfData>");
        return stringBuilder.toString();
    }

    private String getConfiguredPatientIdentification() {
        Attributes attributes = this.permissionsTask.getStudies().getPatient();
        switch (this.pdfOptions.getPatientIdentificationType()) {
            case NONE: {
                return null;
            }
            case PATIENT_NAME: {
                String string = attributes.getString(0x100010);
                return PersonNameUtilities.personNameToHRReverse((PersonName)new PersonName(string, true));
            }
            case PATIENT_ID: {
                return attributes.getString(0x100020);
            }
            case PATIENT_INITIALS: {
                return this.getInitialsFromPatientName(attributes.getString(0x100010));
            }
        }
        return null;
    }

    private String getInitialsFromPatientName(String string) {
        PersonName personName = new PersonName(string, true);
        String string2 = personName.get(PersonName.Component.GivenName);
        String string3 = personName.get(PersonName.Component.MiddleName);
        String string4 = personName.get(PersonName.Component.FamilyName);
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(string2.substring(0, 1).toUpperCase(Locale.getDefault()));
            stringBuilder.append('.');
        }
        if (string3 != null && string3.length() > 0) {
            stringBuilder.append(string3.substring(0, 1).toUpperCase(Locale.getDefault()));
            stringBuilder.append('.');
        }
        if (string4 != null && string4.length() > 0) {
            stringBuilder.append(string4.substring(0, 1).toUpperCase(Locale.getDefault()));
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    private String removeForbiddenXmlCharacters(String string) {
        Matcher matcher = FORBIDDEN_XML_CHARACTERS.matcher(string);
        if (matcher.find()) {
            log.warn("Removing forbidden XML characters from string: {}", (Object)string);
            return matcher.replaceAll("");
        }
        return string;
    }

    protected abstract String getString(StudySharePermission var1);
}

